/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.pairing;

import io.github.hapjava.server.HomekitAuthInfo;
import io.github.hapjava.server.impl.HomekitRegistry;
import io.github.hapjava.server.impl.http.HttpRequest;
import io.github.hapjava.server.impl.http.HttpResponse;
import io.github.hapjava.server.impl.pairing.FinalPairHandler;
import io.github.hapjava.server.impl.pairing.PairSetupRequest;
import io.github.hapjava.server.impl.pairing.SrpHandler;
import io.github.hapjava.server.impl.pairing.Stage;
import io.github.hapjava.server.impl.responses.NotFoundResponse;
import io.github.hapjava.server.impl.responses.UnauthorizedResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PairingManager {
    private static final Logger logger = LoggerFactory.getLogger(PairingManager.class);
    private final HomekitAuthInfo authInfo;
    private final HomekitRegistry registry;
    private SrpHandler srpHandler;

    public PairingManager(HomekitAuthInfo authInfo, HomekitRegistry registry) {
        this.authInfo = authInfo;
        this.registry = registry;
    }

    public HttpResponse handle(HttpRequest httpRequest) throws Exception {
        PairSetupRequest req = PairSetupRequest.of(httpRequest.getBody());
        if (req.getStage() == Stage.ONE) {
            logger.trace("Starting pair for " + this.registry.getLabel());
            this.srpHandler = new SrpHandler(this.authInfo.getPin(), this.authInfo.getSalt());
            return this.srpHandler.handle(req);
        }
        if (req.getStage() == Stage.TWO) {
            logger.trace("Entering second stage of pair for " + this.registry.getLabel());
            if (this.srpHandler == null) {
                logger.warn("Received unexpected stage 2 request for " + this.registry.getLabel());
                return new UnauthorizedResponse();
            }
            try {
                return this.srpHandler.handle(req);
            }
            catch (Exception e) {
                this.srpHandler = null;
                logger.warn("Exception encountered while processing pairing request", (Throwable)e);
                return new UnauthorizedResponse();
            }
        }
        if (req.getStage() == Stage.THREE) {
            logger.trace("Entering third stage of pair for " + this.registry.getLabel());
            if (this.srpHandler == null) {
                logger.warn("Received unexpected stage 3 request for " + this.registry.getLabel());
                return new UnauthorizedResponse();
            }
            FinalPairHandler handler = new FinalPairHandler(this.srpHandler.getK(), this.authInfo);
            try {
                return handler.handle(req);
            }
            catch (Exception e) {
                logger.warn("Exception while finalizing pairing", (Throwable)e);
                return new UnauthorizedResponse();
            }
        }
        return new NotFoundResponse();
    }
}

