/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.services.impl;

import io.github.hapjava.characteristics.Characteristic;
import io.github.hapjava.services.Service;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractServiceImpl
implements Service {
    private final String type;
    private final List<Characteristic> characteristics = new LinkedList<Characteristic>();
    private final List<Service> linkedServices = new LinkedList<Service>();
    private static final Logger logger = LoggerFactory.getLogger(AbstractServiceImpl.class);

    public AbstractServiceImpl(String type) {
        this.type = type;
    }

    @Override
    public List<Characteristic> getCharacteristics() {
        return Collections.unmodifiableList(this.characteristics);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public List<Service> getLinkedServices() {
        return Collections.unmodifiableList(this.linkedServices);
    }

    public void addCharacteristic(Characteristic characteristic) {
        this.characteristics.add(characteristic);
    }

    @Override
    public void addLinkedService(Service service) {
        this.linkedServices.add(service);
    }
}

