/*
 * Decompiled with CFR 0.152.
 */
package com.github.swrirobotics.bags.reader;

import com.github.swrirobotics.bags.reader.BagFileImpl;
import com.github.swrirobotics.bags.reader.MessageHandler;
import com.github.swrirobotics.bags.reader.TopicInfo;
import com.github.swrirobotics.bags.reader.exceptions.BagReaderException;
import com.github.swrirobotics.bags.reader.messages.serialization.MessageType;
import com.github.swrirobotics.bags.reader.records.BagHeader;
import com.github.swrirobotics.bags.reader.records.Chunk;
import com.github.swrirobotics.bags.reader.records.ChunkInfo;
import com.github.swrirobotics.bags.reader.records.Connection;
import com.github.swrirobotics.bags.reader.records.IndexData;
import com.github.swrirobotics.bags.reader.records.MessageData;
import com.github.swrirobotics.bags.reader.records.Record;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.sql.Timestamp;
import java.util.List;
import javax.swing.ProgressMonitor;

public interface BagFile {
    public SeekableByteChannel getChannel() throws IOException;

    public Path getPath();

    public String getVersion();

    public double getDurationS();

    public Timestamp getStartTime();

    public Timestamp getEndTime();

    public BagHeader getBagHeader();

    public List<Chunk> getChunks();

    public List<Connection> getConnections();

    public List<MessageData> getMessages();

    public List<IndexData> getIndexes();

    public List<ChunkInfo> getChunkInfos();

    public void forFirstTopicWithMessagesOfType(String var1, MessageHandler var2) throws BagReaderException;

    public void forMessagesOfType(String var1, MessageHandler var2) throws BagReaderException;

    public void forMessagesOnTopic(String var1, MessageHandler var2) throws BagReaderException;

    public void forMessagesOnConnection(Connection var1, MessageHandler var2) throws BagReaderException;

    public MessageType getFirstMessageOfType(String var1) throws BagReaderException;

    public MessageType getFirstMessageOnTopic(String var1) throws BagReaderException;

    public MessageType getFirstMessageOnConnection(Connection var1) throws BagReaderException;

    public Multimap<String, String> getMessageTypes();

    public List<TopicInfo> getTopics() throws BagReaderException;

    public String getCompressionType();

    public long getMessageCount();

    public boolean isIndexed();

    public MessageType getMessageOnTopicAtIndex(String var1, int var2) throws BagReaderException;

    public MessageType getMessageFromIndex(List<BagFileImpl.MessageIndex> var1, int var2) throws BagReaderException;

    public List<BagFileImpl.MessageIndex> generateIndexesForTopicList(List<String> var1, ProgressMonitor var2) throws BagReaderException, InterruptedException;

    public static Record recordAt(SeekableByteChannel input, long index) throws BagReaderException {
        try {
            input.position(index);
            return new Record(input);
        }
        catch (IOException e) {
            throw new BagReaderException("Unable to seek to position: " + index + "; caught exception " + e);
        }
    }

    public String getUniqueIdentifier() throws BagReaderException;

    public void read() throws BagReaderException;

    public void printInfo() throws BagReaderException;
}

