/*
 * Decompiled with CFR 0.152.
 */
package com.github.swrirobotics.bags.reader;

import com.github.swrirobotics.bags.reader.BagFile;
import com.github.swrirobotics.bags.reader.ByteBufferChannel;
import com.github.swrirobotics.bags.reader.MessageHandler;
import com.github.swrirobotics.bags.reader.TopicInfo;
import com.github.swrirobotics.bags.reader.exceptions.BagReaderException;
import com.github.swrirobotics.bags.reader.exceptions.UnknownMessageException;
import com.github.swrirobotics.bags.reader.messages.serialization.MessageType;
import com.github.swrirobotics.bags.reader.messages.serialization.MsgIterator;
import com.github.swrirobotics.bags.reader.records.BagHeader;
import com.github.swrirobotics.bags.reader.records.Chunk;
import com.github.swrirobotics.bags.reader.records.ChunkInfo;
import com.github.swrirobotics.bags.reader.records.Connection;
import com.github.swrirobotics.bags.reader.records.Header;
import com.github.swrirobotics.bags.reader.records.IndexData;
import com.github.swrirobotics.bags.reader.records.MessageData;
import com.github.swrirobotics.bags.reader.records.Record;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ProgressMonitor;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BagFileImpl
implements BagFile {
    private final Path myPath;
    private static final String version = "2.0";
    private double myDurationS = 0.0;
    private Timestamp myStartTime = null;
    private Timestamp myEndTime = null;
    private BagHeader myBagHeader = null;
    private final List<Chunk> myChunks = Lists.newArrayList();
    private final List<Connection> myConnections = Lists.newArrayList();
    private final Multimap<String, Connection> myConnectionsByTopic = HashMultimap.create();
    private final Multimap<String, Connection> myConnectionsByType = HashMultimap.create();
    private final Multimap<Integer, ChunkInfo> myChunkInfosByConnectionId = HashMultimap.create();
    private final List<MessageData> myMessages = Lists.newArrayList();
    private final List<IndexData> myIndexes = Lists.newArrayList();
    private final List<ChunkInfo> myChunkInfos = Lists.newArrayList();
    private final Map<String, List<MessageIndex>> myMessageIndexesForTopics = Maps.newHashMap();
    private Chunk myPreviousChunk = null;
    private static final Logger myLogger = LoggerFactory.getLogger(BagFile.class);

    public BagFileImpl(String filePath) {
        this.myPath = FileSystems.getDefault().getPath(filePath, new String[0]);
    }

    @Override
    public SeekableByteChannel getChannel() throws IOException {
        return FileChannel.open(this.getPath(), StandardOpenOption.READ);
    }

    @Override
    public Path getPath() {
        return this.myPath;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public double getDurationS() {
        return this.myDurationS;
    }

    @Override
    public Timestamp getStartTime() {
        return this.myStartTime;
    }

    @Override
    public Timestamp getEndTime() {
        return this.myEndTime;
    }

    @Override
    public BagHeader getBagHeader() {
        return this.myBagHeader;
    }

    @Override
    public List<Chunk> getChunks() {
        return this.myChunks;
    }

    @Override
    public List<Connection> getConnections() {
        return this.myConnections;
    }

    private void addConnection(Connection connection) {
        this.myConnections.add(connection);
        this.myConnectionsByTopic.put((Object)connection.getTopic(), (Object)connection);
        this.myConnectionsByType.put((Object)connection.getType(), (Object)connection);
    }

    private void addChunkInfo(ChunkInfo chunkInfo) {
        this.myChunkInfos.add(chunkInfo);
        for (ChunkInfo.ChunkConnection conn : chunkInfo.getConnections()) {
            this.myChunkInfosByConnectionId.put((Object)conn.getConnectionId(), (Object)chunkInfo);
        }
    }

    @Override
    public List<MessageData> getMessages() {
        return this.myMessages;
    }

    @Override
    public List<IndexData> getIndexes() {
        return this.myIndexes;
    }

    @Override
    public List<ChunkInfo> getChunkInfos() {
        return this.myChunkInfos;
    }

    @Override
    public void forFirstTopicWithMessagesOfType(String messageType, MessageHandler handler) throws BagReaderException {
        Iterator iterator = this.myConnectionsByType.get((Object)messageType).iterator();
        if (iterator.hasNext()) {
            Connection conn = (Connection)iterator.next();
            try (SeekableByteChannel channel = this.getChannel();){
                MsgIterator iter = new MsgIterator(this.myChunkInfos, conn, channel);
                while (iter.hasNext()) {
                    boolean keepWorking = handler.process(iter.next(), conn);
                    if (keepWorking) continue;
                    return;
                }
                return;
            }
            catch (IOException e) {
                throw new BagReaderException(e);
            }
        }
    }

    @Override
    public void forMessagesOfType(String messageType, MessageHandler handler) throws BagReaderException {
        for (Connection conn : this.myConnectionsByType.get((Object)messageType)) {
            this.forMessagesOnConnection(conn, handler);
        }
    }

    @Override
    public void forMessagesOnTopic(String topic, MessageHandler handler) throws BagReaderException {
        for (Connection conn : this.myConnectionsByTopic.get((Object)topic)) {
            this.forMessagesOnConnection(conn, handler);
        }
    }

    @Override
    public void forMessagesOnConnection(Connection conn, MessageHandler handler) throws BagReaderException {
        try (SeekableByteChannel channel = this.getChannel();){
            MsgIterator iter = new MsgIterator(this.myChunkInfos, conn, channel);
            while (iter.hasNext()) {
                boolean keepWorking = handler.process(iter.next(), conn);
                if (keepWorking) continue;
                return;
            }
        }
        catch (IOException e) {
            throw new BagReaderException(e);
        }
    }

    @Override
    public MessageType getFirstMessageOfType(String messageType) throws BagReaderException {
        for (Connection conn : this.myConnectionsByType.get((Object)messageType)) {
            MessageType msg = this.getFirstMessageOnConnection(conn);
            if (msg == null) continue;
            return msg;
        }
        return null;
    }

    @Override
    public MessageType getFirstMessageOnTopic(String topic) throws BagReaderException {
        for (Connection conn : this.myConnectionsByTopic.get((Object)topic)) {
            MessageType msg = this.getFirstMessageOnConnection(conn);
            if (msg == null) continue;
            return msg;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MessageType getFirstMessageOnConnection(Connection conn) throws BagReaderException {
        try (SeekableByteChannel channel = this.getChannel();){
            MsgIterator iter = new MsgIterator(this.myChunkInfos, conn, channel);
            if (!iter.hasNext()) return null;
            MessageType messageType = iter.next();
            return messageType;
        }
        catch (IOException e) {
            throw new BagReaderException(e);
        }
    }

    @Override
    public Multimap<String, String> getMessageTypes() {
        HashMultimap mtMap = HashMultimap.create();
        List<Connection> connections = this.getConnections();
        for (Connection connection : connections) {
            mtMap.put((Object)connection.getType(), (Object)connection.getMd5sum());
        }
        return mtMap;
    }

    @Override
    public List<TopicInfo> getTopics() throws BagReaderException {
        HashMap<String, TopicInfo> topicNameMap = new HashMap<String, TopicInfo>();
        HashMap<Integer, TopicInfo> topicConnIdMap = new HashMap<Integer, TopicInfo>();
        for (Connection conn : this.getConnections()) {
            TopicInfo topic = (TopicInfo)topicNameMap.get(conn.getTopic());
            if (topic == null) {
                topic = new TopicInfo(conn.getTopic(), conn.getType(), conn.getMd5sum());
                topicNameMap.put(conn.getTopic(), topic);
            }
            if (!topicConnIdMap.containsKey(conn.getConnectionId())) {
                topicConnIdMap.put(conn.getConnectionId(), topic);
            }
            topic.incrementConnectionCount();
        }
        if (!this.myIndexes.isEmpty()) {
            for (IndexData index : this.myIndexes) {
                TopicInfo info = (TopicInfo)topicConnIdMap.get(index.getConnectionId());
                if (info == null) {
                    throw new BagReaderException("IndexData referred to a connection ID (" + index.getConnectionId() + ") that was not found in the connection data.");
                }
                info.addToMessageCount(index.getCount());
            }
        } else {
            for (ChunkInfo info : this.myChunkInfos) {
                for (ChunkInfo.ChunkConnection conn : info.getConnections()) {
                    TopicInfo topic = (TopicInfo)topicConnIdMap.get(conn.getConnectionId());
                    if (topic == null) {
                        throw new BagReaderException("ChunkInfo referred to a connection ID (" + conn.getConnectionId() + ") that was not found in the connection data.");
                    }
                    topic.addToMessageCount(conn.getMessageCount());
                }
            }
        }
        ArrayList list = Lists.newArrayList(topicNameMap.values());
        Collections.sort(list);
        return list;
    }

    @Override
    public String getCompressionType() {
        long lz4Count = 0L;
        long bz2Count = 0L;
        for (Chunk chunk : this.myChunks) {
            String compression = chunk.getCompression();
            if (compression.equals("bz2")) {
                ++bz2Count;
                continue;
            }
            if (!compression.equals("lz4")) continue;
            ++lz4Count;
        }
        ArrayList chunkPositions = Lists.newArrayListWithExpectedSize((int)this.myChunkInfos.size());
        for (ChunkInfo info : this.myChunkInfos) {
            chunkPositions.add(info.getChunkPos());
        }
        try (SeekableByteChannel seekableByteChannel = this.getChannel();){
            for (Long chunkPos : chunkPositions) {
                Chunk chunk = new Chunk(BagFileImpl.recordAt(seekableByteChannel, chunkPos));
                String compression = chunk.getCompression();
                if (compression.equals("bz2")) {
                    ++bz2Count;
                    continue;
                }
                if (!compression.equals("lz4")) continue;
                ++lz4Count;
            }
        }
        catch (BagReaderException | IOException exception) {
            myLogger.warn("Error reading data chunk", (Throwable)exception);
        }
        if (lz4Count > bz2Count) {
            return "lz4";
        }
        if (bz2Count > lz4Count && bz2Count != 0L) {
            return "bz2";
        }
        return "none";
    }

    @Override
    public long getMessageCount() {
        long count = 0L;
        if (!this.myIndexes.isEmpty()) {
            for (IndexData index : this.myIndexes) {
                count += (long)index.getCount();
            }
        } else {
            for (ChunkInfo info : this.myChunkInfos) {
                for (ChunkInfo.ChunkConnection conn : info.getConnections()) {
                    count += (long)conn.getMessageCount();
                }
            }
        }
        return count;
    }

    @Override
    public boolean isIndexed() {
        return !this.myIndexes.isEmpty();
    }

    @Override
    public MessageType getMessageOnTopicAtIndex(String topic, int index) throws BagReaderException {
        List<MessageIndex> indexes = this.myMessageIndexesForTopics.get(topic = topic.trim());
        if (indexes == null) {
            indexes = this.generateIndexesForTopic(topic);
        }
        if (index >= indexes.size()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.getMessageType(topic, index, indexes);
    }

    private MessageType getMessageType(String topic, int index, List<MessageIndex> indexes) throws BagReaderException {
        MessageType mt;
        try {
            Connection conn = (Connection)this.myConnectionsByTopic.get((Object)topic).iterator().next();
            mt = conn.getMessageCollection().getMessageType();
        }
        catch (UnknownMessageException e) {
            throw new BagReaderException(e);
        }
        try (SeekableByteChannel channel = this.getChannel();){
            MessageIndex msgIndex = indexes.get(index);
            Record record = BagFile.recordAt(channel, msgIndex.fileIndex);
            ByteBufferChannel chunkChannel = new ByteBufferChannel(record.getData());
            Record message = BagFile.recordAt(chunkChannel, msgIndex.chunkIndex);
            mt.readMessage(message);
        }
        catch (IOException e) {
            throw new BagReaderException(e);
        }
        return mt;
    }

    @Override
    public MessageType getMessageFromIndex(List<MessageIndex> indexes, int index) throws BagReaderException {
        if (index >= indexes.size()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        String topic = indexes.get((int)index).topic;
        return this.getMessageType(topic, index, indexes);
    }

    private List<MessageIndex> generateIndexesForTopic(String topic) throws BagReaderException {
        ArrayList msgIndexes = Lists.newArrayList();
        try (SeekableByteChannel channel = this.getChannel();){
            for (Connection conn : this.myConnectionsByTopic.get((Object)topic)) {
                for (ChunkInfo chunkInfo : this.myChunkInfosByConnectionId.get((Object)conn.getConnectionId())) {
                    long chunkPos = chunkInfo.getChunkPos();
                    this.getIndexesForChunk(channel, topic, msgIndexes, conn, chunkPos);
                }
            }
        }
        catch (IOException e) {
            throw new BagReaderException(e);
        }
        Collections.sort(msgIndexes);
        this.myMessageIndexesForTopics.put(topic, msgIndexes);
        return msgIndexes;
    }

    @Override
    public List<MessageIndex> generateIndexesForTopicList(List<String> topics, ProgressMonitor progressMonitor) throws BagReaderException, InterruptedException {
        int totalNumChunks = 0;
        int currentTotalChunkNum = 0;
        if (progressMonitor != null) {
            for (String topic : topics) {
                Collection connList = this.myConnectionsByTopic.get((Object)topic);
                for (Connection conn : connList) {
                    Collection chunkColl = this.myChunkInfosByConnectionId.get((Object)conn.getConnectionId());
                    totalNumChunks += chunkColl.size();
                }
            }
            progressMonitor.setMinimum(0);
            progressMonitor.setMaximum(totalNumChunks);
            if (progressMonitor.isCanceled()) {
                throw new InterruptedException();
            }
        }
        ArrayList msgIndexes = Lists.newArrayList();
        try (SeekableByteChannel channel = this.getChannel();){
            for (String topic : topics) {
                if (progressMonitor != null) {
                    progressMonitor.setNote("generating index for topic " + topic);
                }
                myLogger.info("generating index for topic " + topic);
                ArrayList msgIndex = Lists.newArrayList();
                int connNum = 0;
                Collection connList = this.myConnectionsByTopic.get((Object)topic);
                int numConns = connList.size();
                for (Connection conn : connList) {
                    myLogger.info("\tConnection " + conn + " (" + connNum + "/" + numConns + ")");
                    ++connNum;
                    Collection chunkColl = this.myChunkInfosByConnectionId.get((Object)conn.getConnectionId());
                    int chunkNum = 0;
                    int numChunks = chunkColl.size();
                    for (ChunkInfo chunkInfo : chunkColl) {
                        long chunkPos = chunkInfo.getChunkPos();
                        if (chunkNum % 500 == 0) {
                            myLogger.info("\t\tChunk " + chunkNum + "/" + numChunks);
                        }
                        ++chunkNum;
                        if (progressMonitor != null) {
                            if (progressMonitor.isCanceled()) {
                                progressMonitor.setNote("canceling");
                                throw new InterruptedException("canceled indexing");
                            }
                            progressMonitor.setProgress(currentTotalChunkNum++);
                        }
                        this.getIndexesForChunk(channel, topic, msgIndex, conn, chunkPos);
                    }
                }
                this.myMessageIndexesForTopics.put(topic, msgIndex);
                msgIndexes.addAll(msgIndex);
            }
        }
        catch (IOException e) {
            throw new BagReaderException(e);
        }
        myLogger.info("sorting combined index with " + msgIndexes.size() + " messages");
        if (progressMonitor != null) {
            if (progressMonitor.isCanceled()) {
                throw new InterruptedException("canceled sorting index");
            }
            progressMonitor.setNote("sorting index");
            progressMonitor.setProgress(totalNumChunks);
        }
        Collections.sort(msgIndexes);
        if (progressMonitor != null) {
            progressMonitor.setNote("done sorting");
        }
        return msgIndexes;
    }

    private void getIndexesForChunk(SeekableByteChannel channel, String topic, List<MessageIndex> msgIndex, Connection conn, long chunkPos) throws BagReaderException, IOException {
        Record chunk = BagFile.recordAt(channel, chunkPos);
        chunk.readData();
        ByteBufferChannel chunkChannel = new ByteBufferChannel(chunk.getData());
        while (chunkChannel.position() < chunkChannel.size()) {
            long position = chunkChannel.position();
            Record msg = new Record(chunkChannel);
            msg.readData();
            if (msg.getHeader().getType() != Record.RecordType.MESSAGE_DATA || msg.getHeader().getInt("conn") != conn.getConnectionId()) continue;
            Timestamp t = msg.getHeader().getTimestamp("time");
            msgIndex.add(new MessageIndex(chunkPos, position, topic, t));
        }
    }

    private void verifyBagFile(ReadableByteChannel myInput) throws BagReaderException {
        int bytesRead;
        ByteBuffer buffer = ByteBuffer.allocate(13);
        try {
            bytesRead = myInput.read(buffer);
        }
        catch (IOException e) {
            throw new BagReaderException(e);
        }
        if (bytesRead != 13) {
            throw new BagReaderException("Expected to read 13 bytes but only got " + bytesRead + ".");
        }
        String line = new String(buffer.array());
        if (!"#ROSBAG V2.0\n".equals(line)) {
            throw new BagReaderException("File did not start with the proper ROSBAG header.  Actual first 13 bytes: [" + line + "]");
        }
    }

    private boolean hasNext(SeekableByteChannel input) throws BagReaderException {
        try {
            return input.position() < input.size();
        }
        catch (IOException e) {
            throw new BagReaderException("Unable to count remaining bytes.");
        }
    }

    public static Record recordAt(SeekableByteChannel input, long index) throws BagReaderException {
        try {
            input.position(index);
            return new Record(input);
        }
        catch (IOException e) {
            throw new BagReaderException("Unable to seek to position: " + index + "; caught exception " + e);
        }
    }

    @Override
    public String getUniqueIdentifier() throws BagReaderException {
        MessageDigest digest = DigestUtils.getMd5Digest();
        if (this.myBagHeader == null) {
            this.read();
        }
        digest.update(Ints.toByteArray((int)this.myBagHeader.getChunkCount()));
        digest.update(Ints.toByteArray((int)this.myBagHeader.getConnCount()));
        digest.update(Longs.toByteArray((long)this.myBagHeader.getIndexPos()));
        for (Chunk chunk : this.getChunks()) {
            digest.update(chunk.getCompression().getBytes());
            digest.update(Ints.toByteArray((int)chunk.getSize()));
        }
        for (Connection connection : this.getConnections()) {
            if (connection.getCallerId() != null) {
                digest.update(connection.getCallerId().getBytes());
            }
            digest.update(Ints.toByteArray((int)connection.getConnectionId()));
            digest.update(connection.getMd5sum().getBytes());
            digest.update(connection.getTopic().getBytes());
            digest.update(connection.getMessageDefinition().getBytes());
        }
        for (MessageData messageData : this.getMessages()) {
            digest.update(Ints.toByteArray((int)messageData.getConnectionId()));
            digest.update(Longs.toByteArray((long)messageData.getTime().getTime()));
        }
        for (IndexData indexData : this.getIndexes()) {
            digest.update(Ints.toByteArray((int)indexData.getConnectionId()));
            digest.update(Ints.toByteArray((int)indexData.getCount()));
            Object object = indexData.getIndexes().iterator();
            while (object.hasNext()) {
                IndexData.Index index = (IndexData.Index)object.next();
                digest.update(Longs.toByteArray((long)index.getTime().getTime()));
                digest.update(Ints.toByteArray((int)index.getOffset()));
            }
        }
        for (ChunkInfo chunkInfo : this.getChunkInfos()) {
            digest.update(Longs.toByteArray((long)chunkInfo.getChunkPos()));
            digest.update(Ints.toByteArray((int)chunkInfo.getCount()));
            digest.update(Longs.toByteArray((long)chunkInfo.getEndTime().getTime()));
            digest.update(Longs.toByteArray((long)chunkInfo.getStartTime().getTime()));
            for (ChunkInfo.ChunkConnection conn : chunkInfo.getConnections()) {
                digest.update(Ints.toByteArray((int)conn.getConnectionId()));
                digest.update(Ints.toByteArray((int)conn.getMessageCount()));
            }
        }
        StringBuilder builder = new StringBuilder();
        byte[] byArray = digest.digest();
        for (byte b : byArray) {
            builder.append(Integer.toHexString(b & 0xFF | 0x100), 1, 3);
        }
        return builder.toString();
    }

    @Override
    public void read() throws BagReaderException {
        if (this.myBagHeader != null) {
            return;
        }
        try (SeekableByteChannel input = this.getChannel();){
            this.verifyBagFile(input);
            block15: while (this.hasNext(input)) {
                Record record = new Record(input);
                switch (record.getHeader().getType()) {
                    case BAG_HEADER: {
                        this.myBagHeader = new BagHeader(record);
                        if (this.getBagHeader().getIndexPos() == 0L) {
                            throw new BagReaderException("Unable to read bag header; reindex the bag file.");
                        }
                        input.position(this.getBagHeader().getIndexPos());
                        continue block15;
                    }
                    case CHUNK: {
                        this.myPreviousChunk = new Chunk(record);
                        this.getChunks().add(this.myPreviousChunk);
                        continue block15;
                    }
                    case CONNECTION: {
                        record.setConnectionHeader(new Header(record.getData()));
                        this.addConnection(new Connection(record));
                        continue block15;
                    }
                    case MESSAGE_DATA: {
                        this.getMessages().add(new MessageData(record));
                        continue block15;
                    }
                    case INDEX_DATA: {
                        if (this.myPreviousChunk == null) {
                            throw new BagReaderException("No chunk found for index at position " + input.position());
                        }
                        this.getIndexes().add(new IndexData(record, this.myPreviousChunk));
                        continue block15;
                    }
                    case CHUNK_INFO: {
                        this.addChunkInfo(new ChunkInfo(record));
                        continue block15;
                    }
                }
                throw new BagReaderException("Unknown header type.");
            }
        }
        catch (IOException e) {
            throw new BagReaderException(e);
        }
        for (ChunkInfo info : this.myChunkInfos) {
            this.myStartTime = BagFileImpl.minTimestamp(this.myStartTime, info.getStartTime());
            this.myStartTime = BagFileImpl.minTimestamp(this.myStartTime, info.getEndTime());
            this.myEndTime = BagFileImpl.maxTimestamp(this.myEndTime, info.getStartTime());
            this.myEndTime = BagFileImpl.maxTimestamp(this.myEndTime, info.getEndTime());
        }
        for (IndexData indexData : this.myIndexes) {
            for (IndexData.Index index : indexData.getIndexes()) {
                this.myStartTime = BagFileImpl.minTimestamp(this.myStartTime, index.getTime());
                this.myEndTime = BagFileImpl.maxTimestamp(this.myEndTime, index.getTime());
            }
        }
        if (this.getStartTime() != null && this.getEndTime() != null && this.getStartTime().getTime() != 0L && this.getEndTime().getTime() != 0L) {
            this.myDurationS = (double)(this.getEndTime().getTime() - this.getStartTime().getTime()) / 1000.0;
        } else {
            myLogger.warn("No chunk info records found; start and end time are unknown.");
            myLogger.warn("Record type counts:\n  Header: " + (this.getBagHeader() == null ? 0 : 1) + "\n  Chunk: " + this.getChunks().size() + "\n  Connection: " + this.getConnections().size() + "\n  Message Data: " + this.getMessages().size() + "\n  Index Data: " + this.getIndexes().size() + "\n  Chunk Info: " + this.getChunkInfos().size());
        }
        if (this.getBagHeader().getChunkCount() != this.getChunks().size() + this.getChunkInfos().size() || this.getBagHeader().getConnCount() != this.getConnections().size()) {
            String errorMsg = "Expected " + this.getBagHeader().getChunkCount() + " chunks and " + this.getBagHeader().getConnCount() + " connections, but got " + (this.getChunks().size() + this.getChunkInfos().size()) + " and " + this.getConnections().size() + ".  This is ok if the file is in the middle of being written to disk, otherwise the bag may be corrupt.";
            myLogger.warn(errorMsg);
            throw new BagReaderException(errorMsg);
        }
    }

    private static Timestamp minTimestamp(Timestamp left, Timestamp right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        if (left.compareTo(right) < 0) {
            return left;
        }
        return right;
    }

    private static Timestamp maxTimestamp(Timestamp left, Timestamp right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        if (left.compareTo(right) > 0) {
            return left;
        }
        return right;
    }

    @Override
    public void printInfo() throws BagReaderException {
        myLogger.info("Version:     " + this.getVersion());
        myLogger.info("Compression: " + this.getCompressionType());
        myLogger.info("Duration:    " + this.getDurationS() + "s");
        myLogger.info("Start:       " + (this.getStartTime() == null ? "Unknown" : this.getStartTime().toString() + " (" + this.getStartTime().getTime() + ")"));
        myLogger.info("End:         " + (this.getEndTime() == null ? "Unknown" : this.getEndTime().toString() + " (" + this.getEndTime().getTime() + ")"));
        myLogger.info("Size:        " + (double)this.getPath().toFile().length() / 1024.0 + " MB");
        myLogger.info("Messages:    " + this.getMessageCount());
        myLogger.info("Types:");
        for (Map.Entry entry : this.getMessageTypes().entries()) {
            myLogger.info("  " + (String)entry.getKey() + " \t\t[" + (String)entry.getValue() + "]");
        }
        myLogger.info("Topics:");
        for (TopicInfo topic : this.getTopics()) {
            myLogger.info("  " + topic.getName() + " \t\t" + topic.getMessageCount() + " msgs \t: " + topic.getMessageType() + " \t" + (topic.getConnectionCount() > 1L ? "(" + topic.getConnectionCount() + " connections)" : ""));
        }
    }

    public static class MessageIndex
    implements Comparable<MessageIndex>,
    Serializable {
        private static final long serialVersionUID = 0L;
        public long fileIndex;
        public long chunkIndex;
        public String topic;
        public Timestamp timestamp;

        public MessageIndex(long fileIndex, long chunkIndex, String topic, Timestamp timestamp) {
            this.fileIndex = fileIndex;
            this.chunkIndex = chunkIndex;
            this.topic = topic;
            this.timestamp = timestamp;
        }

        @Override
        public int compareTo(MessageIndex o) {
            if (this.timestamp == null || o.timestamp == null) {
                int result = Long.compare(this.fileIndex, o.fileIndex);
                if (result != 0) {
                    return result;
                }
                return Long.compare(this.chunkIndex, o.chunkIndex);
            }
            return this.timestamp.compareTo(o.timestamp);
        }

        public String toString() {
            return "MessageIndex{fileIndex=" + this.fileIndex + ", chunkIndex=" + this.chunkIndex + ", topic=" + this.topic + ", timestamp=" + this.timestamp + '}';
        }
    }
}

