/*
 * Decompiled with CFR 0.152.
 */
package com.github.swrirobotics.bags.reader;

import com.github.swrirobotics.bags.reader.BagFile;
import com.github.swrirobotics.bags.reader.BagFileImpl;
import com.github.swrirobotics.bags.reader.exceptions.BagReaderException;
import com.github.swrirobotics.bags.reader.exceptions.UninitializedFieldException;
import com.github.swrirobotics.bags.reader.messages.serialization.Float64Type;
import com.github.swrirobotics.bags.reader.messages.serialization.MessageType;
import java.io.File;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BagReader {
    private static final Logger myLogger = LoggerFactory.getLogger(BagReader.class);

    public static BagFile readFile(File file) throws BagReaderException {
        BagFileImpl bag = new BagFileImpl(file.getAbsolutePath());
        bag.read();
        return bag;
    }

    public static BagFile readFile(String filename) throws BagReaderException {
        BagFileImpl bag = new BagFileImpl(filename);
        bag.read();
        return bag;
    }

    public static void main(String[] args) throws BagReaderException, UninitializedFieldException {
        myLogger.info("Reading bag files.");
        ArrayList<BagFile> bags = new ArrayList<BagFile>();
        for (String arg : args) {
            myLogger.info("Reading " + arg);
            try {
                bags.add(BagReader.readFile(arg));
            }
            catch (BagReaderException e) {
                myLogger.warn("Unable to read bag file: " + arg, (Throwable)e);
            }
        }
        myLogger.info("Successfully read " + bags.size() + " bags.");
        for (BagFile bag : bags) {
            myLogger.info("Path:     " + bag.getPath().toString());
            bag.printInfo();
            MessageType msg = bag.getFirstMessageOfType("gps_common/GPSFix");
            if (msg == null) {
                msg = bag.getFirstMessageOfType("sensor_msgs/NavSatFix");
            }
            if (msg == null) {
                msg = bag.getFirstMessageOfType("marti_gps_common/GPSFix");
            }
            if (msg != null) {
                myLogger.info("Lat/Lon: " + ((Float64Type)msg.getField("latitude")).getValue() + " / " + ((Float64Type)msg.getField("longitude")).getValue());
            }
            myLogger.info("Bag fingerprint: " + bag.getUniqueIdentifier());
        }
    }
}

