/*
 * Decompiled with CFR 0.152.
 */
package com.github.swrirobotics.bags.reader.messages.serialization;

import com.github.swrirobotics.bags.reader.exceptions.BagReaderException;
import com.github.swrirobotics.bags.reader.exceptions.InvalidDefinitionException;
import com.github.swrirobotics.bags.reader.exceptions.UnknownMessageException;
import com.github.swrirobotics.bags.reader.messages.serialization.ArrayType;
import com.github.swrirobotics.bags.reader.messages.serialization.BoolType;
import com.github.swrirobotics.bags.reader.messages.serialization.DurationType;
import com.github.swrirobotics.bags.reader.messages.serialization.Field;
import com.github.swrirobotics.bags.reader.messages.serialization.Float32Type;
import com.github.swrirobotics.bags.reader.messages.serialization.Float64Type;
import com.github.swrirobotics.bags.reader.messages.serialization.Int16Type;
import com.github.swrirobotics.bags.reader.messages.serialization.Int32Type;
import com.github.swrirobotics.bags.reader.messages.serialization.Int64Type;
import com.github.swrirobotics.bags.reader.messages.serialization.Int8Type;
import com.github.swrirobotics.bags.reader.messages.serialization.MessageCollection;
import com.github.swrirobotics.bags.reader.messages.serialization.PrimitiveType;
import com.github.swrirobotics.bags.reader.messages.serialization.StringType;
import com.github.swrirobotics.bags.reader.messages.serialization.TimeType;
import com.github.swrirobotics.bags.reader.messages.serialization.UInt16Type;
import com.github.swrirobotics.bags.reader.messages.serialization.UInt32Type;
import com.github.swrirobotics.bags.reader.messages.serialization.UInt64Type;
import com.github.swrirobotics.bags.reader.messages.serialization.UInt8Type;
import com.github.swrirobotics.bags.reader.records.MessageData;
import com.github.swrirobotics.bags.reader.records.Record;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageType
implements Field {
    private String myPackage;
    private String myType;
    private String myMd5Sum;
    private MessageData myMsgData = null;
    private String myName = null;
    private MessageCollection myMsgCollection;
    private static final boolean COLLECT_STATS = false;
    private static final Map<String, Map<String, List<Long>>> STATS = Maps.newHashMap();
    private final List<Field> myFields = Lists.newArrayList();
    private final Map<String, Field> myFieldNameMap = Maps.newHashMap();
    private static final Logger myLogger = LoggerFactory.getLogger(MessageType.class);
    private static final Splitter LINE_SPLITTER = Splitter.on((char)'\n').trimResults().omitEmptyStrings();
    private static final Splitter NAME_SPLITTER = Splitter.on((char)'/').trimResults().omitEmptyStrings();
    private static final Pattern FIELD_PATTERN = Pattern.compile("^\\s*([\\w/\\[\\]]+)\\s+([\\w]+)\\s*(?:=\\s*([^\\s]+))?.*#?.*$");
    private static final Pattern ARRAY_PATTERN = Pattern.compile("^([\\w/]+)\\[(\\d*)\\]$");
    private static final Pattern STRING_CONST_PATTERN = Pattern.compile("^\\s*string\\s+\\w+\\s*=.*$");
    private static final Pattern CONST_PATTERN = Pattern.compile("^\\w+=.+$");
    private static final Pattern PRIMITIVE_PATTERN = Pattern.compile("^((bool)|(char)|(byte)|(u?int((8)|(16)|(32)|(64)))|(float((32)|(64)))|(string)|(time)|(duration)).*$");
    private static final Pattern TYPE_PATTERN = Pattern.compile("^(([\\w/]+)(?:\\s*\\[\\s*\\d*\\s*\\])?).*$");

    public MessageType(String definition, MessageCollection msgCollection) throws InvalidDefinitionException, UnknownMessageException {
        this.myMsgCollection = msgCollection;
        Iterable lines = LINE_SPLITTER.split((CharSequence)definition);
        Iterator iter = lines.iterator();
        if (!iter.hasNext()) {
            throw new InvalidDefinitionException("Message definition had no lines.");
        }
        String typeStr = (String)iter.next();
        if (!typeStr.startsWith("MSG: ")) {
            throw new InvalidDefinitionException("Message definition did not start with \"MSG: \":\n" + typeStr);
        }
        List type = NAME_SPLITTER.splitToList((CharSequence)(typeStr = typeStr.replace("MSG: ", "")));
        if (type.size() != 2) {
            throw new InvalidDefinitionException("Unable to parse message type: \"" + typeStr + "\"");
        }
        this.myPackage = (String)type.get(0);
        this.myType = (String)type.get(1);
        myLogger.debug("Parsing message type: " + this.myPackage + "/" + this.myType);
        while (iter.hasNext()) {
            String line = ((String)iter.next()).trim();
            if (line.isEmpty() || line.startsWith("#")) continue;
            Matcher fieldMatcher = FIELD_PATTERN.matcher(line);
            if (!fieldMatcher.matches()) {
                throw new InvalidDefinitionException("Unable to parse field definition: \n" + line);
            }
            String fieldType = fieldMatcher.group(1);
            String fieldName = fieldMatcher.group(2);
            String defaultVal = null;
            if (fieldMatcher.groupCount() == 3) {
                defaultVal = fieldMatcher.group(3);
            }
            Field field = this.createField(fieldType, fieldName, defaultVal);
            this.myFields.add(field);
            this.myFieldNameMap.put(field.getName(), field);
        }
        try {
            this.myMd5Sum = this.calculateMd5Sum(definition);
        }
        catch (UnknownMessageException e) {
            myLogger.error("Error calculating md5sum", (Throwable)e);
        }
        myLogger.debug("MD5Sum: " + this.myMd5Sum);
    }

    private MessageType() {
    }

    private String calculateMd5Sum(String definition) throws UnknownMessageException {
        List rawLines = LINE_SPLITTER.splitToList((CharSequence)definition);
        ArrayList constants = Lists.newArrayList();
        ArrayList nonconstants = Lists.newArrayList();
        for (String line : rawLines) {
            Matcher typeMatcher;
            if ((line = line.trim()).startsWith("MSG:")) continue;
            if (!STRING_CONST_PATTERN.matcher(line).matches()) {
                line = line.replaceAll("\\s*#.*$", "");
            }
            if (line.isEmpty()) continue;
            if (!PRIMITIVE_PATTERN.matcher(line).matches() && (typeMatcher = TYPE_PATTERN.matcher(line)).matches()) {
                String type = typeMatcher.group(2);
                List typeParts = NAME_SPLITTER.splitToList((CharSequence)type);
                MessageType mt = typeParts.size() == 1 ? this.myMsgCollection.getMessageType((String)typeParts.get(0)) : this.myMsgCollection.getMessageType((String)typeParts.get(0), (String)typeParts.get(1));
                line = line.replace(typeMatcher.group(1), mt.getMd5Sum());
            }
            if (CONST_PATTERN.matcher(line).matches()) {
                constants.add(line);
                continue;
            }
            nonconstants.add(line);
        }
        ArrayList filteredLines = Lists.newArrayList();
        filteredLines.addAll(constants);
        filteredLines.addAll(nonconstants);
        String filteredText = Joiner.on((String)"\n").skipNulls().join((Iterable)filteredLines);
        try {
            byte[] md5sum = MessageDigest.getInstance("MD5").digest(filteredText.getBytes());
            StringBuilder builder = new StringBuilder();
            for (byte b : md5sum) {
                builder.append(Integer.toHexString(b & 0xFF | 0x100), 1, 3);
            }
            return builder.toString();
        }
        catch (NoSuchAlgorithmException e) {
            myLogger.error("Unable to get MD5 algorithm.");
            return "";
        }
    }

    @Override
    public MessageType copy() {
        MessageType mt = new MessageType();
        mt.myPackage = this.myPackage;
        mt.myType = this.myType;
        mt.myMd5Sum = this.myMd5Sum;
        mt.myMsgCollection = this.myMsgCollection;
        mt.myMsgData = this.myMsgData;
        mt.myName = this.myName;
        for (Field field : this.myFields) {
            Field newField = field.copy();
            mt.myFields.add(newField);
            mt.myFieldNameMap.put(newField.getName(), newField);
        }
        return mt;
    }

    public void readMessage(Record record) throws BagReaderException {
        this.myMsgData = new MessageData(record);
        this.readMessage(record.getData().order(ByteOrder.LITTLE_ENDIAN));
    }

    @Override
    public void readMessage(ByteBuffer buffer) {
        long startTimeNs = 0L;
        for (Field field : this.myFields) {
            field.readMessage(buffer);
        }
        long finishTimeNs = System.nanoTime();
    }

    @Override
    public void reset() {
        for (Field field : this.myFields) {
            field.reset();
        }
    }

    private Field createField(String type, String name, String defaultVal) throws UnknownMessageException {
        Field field;
        String baseType;
        Matcher m = ARRAY_PATTERN.matcher(type);
        boolean isArray = m.matches();
        int arraySize = 0;
        if (isArray) {
            baseType = m.group(1);
            if (!m.group(2).isEmpty()) {
                arraySize = Integer.parseInt(m.group(2));
            }
        } else {
            baseType = type;
        }
        switch (baseType) {
            case "bool": {
                field = new BoolType();
                break;
            }
            case "int8": 
            case "byte": {
                field = new Int8Type();
                break;
            }
            case "uint8": 
            case "char": {
                field = new UInt8Type();
                break;
            }
            case "int16": {
                field = new Int16Type();
                break;
            }
            case "uint16": {
                field = new UInt16Type();
                break;
            }
            case "int32": {
                field = new Int32Type();
                break;
            }
            case "uint32": {
                field = new UInt32Type();
                break;
            }
            case "int64": {
                field = new Int64Type();
                break;
            }
            case "uint64": {
                field = new UInt64Type();
                break;
            }
            case "float32": {
                field = new Float32Type();
                break;
            }
            case "float64": {
                field = new Float64Type();
                break;
            }
            case "string": {
                field = new StringType();
                break;
            }
            case "time": {
                field = new TimeType();
                break;
            }
            case "duration": {
                field = new DurationType();
                break;
            }
            default: {
                List nameParts = NAME_SPLITTER.splitToList((CharSequence)baseType);
                field = nameParts.size() == 1 ? this.myMsgCollection.getMessageType(baseType) : this.myMsgCollection.getMessageType((String)nameParts.get(0), (String)nameParts.get(1));
            }
        }
        if (isArray) {
            field = new ArrayType(field, arraySize);
        }
        field.setName(name);
        if (defaultVal != null && field instanceof PrimitiveType) {
            ((PrimitiveType)field).setDefaultValue(defaultVal);
        }
        return field;
    }

    public List<String> getFieldNames() {
        return Lists.newArrayList(this.myFieldNameMap.keySet());
    }

    @Override
    public String getType() {
        return this.myType;
    }

    public String getPackage() {
        return this.myPackage;
    }

    public String getMd5Sum() {
        return this.myMd5Sum;
    }

    public MessageData getMessageData() {
        return this.myMsgData;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void setName(String name) {
        this.myName = name;
    }

    public <T extends Field> T getField(String name) {
        return (T)this.myFieldNameMap.get(name);
    }

    public static void printStats() {
        myLogger.warn("set MessageType.COLLECT_STATS=true to collect timing statistics");
    }

    private static /* synthetic */ List lambda$readMessage$1(String k) {
        return Lists.newArrayList();
    }

    private static /* synthetic */ Map lambda$readMessage$0(String k) {
        return Maps.newHashMap();
    }
}

