/*
 * Decompiled with CFR 0.152.
 */
package com.github.swrirobotics.bags.reader.records;

import com.github.swrirobotics.bags.reader.BagFile;
import com.github.swrirobotics.bags.reader.exceptions.BagReaderException;
import com.github.swrirobotics.bags.reader.records.ChunkInfo;
import com.github.swrirobotics.bags.reader.records.Record;
import java.nio.channels.SeekableByteChannel;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkRecordIterator
implements Iterator<Record> {
    private final SeekableByteChannel myInput;
    private final Iterator<ChunkInfo> myChunkIter;
    private final int myConnId;
    private Record myNextRecord = null;
    private static final Logger myLogger = LoggerFactory.getLogger(ChunkRecordIterator.class);

    public ChunkRecordIterator(int connectionId, SeekableByteChannel input, List<ChunkInfo> chunkInfos) {
        this.myConnId = connectionId;
        this.myInput = input;
        this.myChunkIter = chunkInfos.iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.myNextRecord == null) {
            this.myNextRecord = this.findNext();
        }
        return this.myNextRecord != null;
    }

    @Override
    public Record next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Record tmp = this.myNextRecord;
        this.myNextRecord = null;
        return tmp;
    }

    private Record findNext() {
        if (!this.myChunkIter.hasNext()) {
            return null;
        }
        long chunkPos = -1L;
        block2: while (this.myChunkIter.hasNext() && chunkPos == -1L) {
            ChunkInfo info = this.myChunkIter.next();
            for (ChunkInfo.ChunkConnection conn : info.getConnections()) {
                if (conn.getConnectionId() != this.myConnId) continue;
                chunkPos = info.getChunkPos();
                continue block2;
            }
        }
        if (chunkPos == -1L) {
            return null;
        }
        try {
            Record chunk = BagFile.recordAt(this.myInput, chunkPos);
            chunk.readData();
            return chunk;
        }
        catch (BagReaderException e) {
            myLogger.warn("Error reading data chunk", (Throwable)e);
            return null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

