/*
 * Decompiled with CFR 0.152.
 */
package com.github.swrirobotics.bags.reader.records;

import com.github.swrirobotics.bags.reader.exceptions.BagReaderException;
import com.github.swrirobotics.bags.reader.exceptions.InvalidDefinitionException;
import com.github.swrirobotics.bags.reader.messages.serialization.MessageCollection;
import com.github.swrirobotics.bags.reader.records.Record;
import org.slf4j.LoggerFactory;

public class Connection {
    private final int myConnectionId;
    private final String myTopic;
    private final String myType;
    private final String myMd5sum;
    private final String myMessageDefinition;
    private String myCallerId;
    private Boolean myLatching;
    private final MessageCollection myMsgCollection = new MessageCollection();

    public Connection(Record record) throws BagReaderException {
        this.myConnectionId = record.getHeader().getInt("conn");
        this.myTopic = record.getHeader().getValue("topic");
        this.myType = record.getConnectionHeader().getValue("type");
        this.myMd5sum = record.getConnectionHeader().getValue("md5sum");
        this.myMessageDefinition = record.getConnectionHeader().getValue("message_definition");
        try {
            this.myMsgCollection.setTopType(this.myType);
            this.myMsgCollection.parseMessages(this.myMessageDefinition);
        }
        catch (InvalidDefinitionException e) {
            LoggerFactory.getLogger(Connection.class).error("Error configuring message deserializer: ", (Throwable)e);
        }
        try {
            this.myCallerId = record.getConnectionHeader().getValue("callerid");
        }
        catch (BagReaderException e) {
            this.myCallerId = null;
        }
        try {
            this.myLatching = Boolean.parseBoolean(record.getConnectionHeader().getValue("latching"));
        }
        catch (BagReaderException e) {
            this.myLatching = null;
        }
    }

    public int getConnectionId() {
        return this.myConnectionId;
    }

    public String getTopic() {
        return this.myTopic;
    }

    public String getType() {
        return this.myType;
    }

    public String getMd5sum() {
        return this.myMd5sum;
    }

    public String getMessageDefinition() {
        return this.myMessageDefinition;
    }

    public String getCallerId() {
        return this.myCallerId;
    }

    public Boolean getLatching() {
        return this.myLatching;
    }

    public MessageCollection getMessageCollection() {
        return this.myMsgCollection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Connection that = (Connection)o;
        if (this.myConnectionId != that.myConnectionId) {
            return false;
        }
        if (!this.myTopic.equals(that.myTopic)) {
            return false;
        }
        if (!this.myType.equals(that.myType)) {
            return false;
        }
        if (!this.myMd5sum.equals(that.myMd5sum)) {
            return false;
        }
        if (!this.myMessageDefinition.equals(that.myMessageDefinition)) {
            return false;
        }
        if (this.myCallerId != null ? !this.myCallerId.equals(that.myCallerId) : that.myCallerId != null) {
            return false;
        }
        return !(this.myLatching == null ? that.myLatching != null : !this.myLatching.equals(that.myLatching));
    }

    public int hashCode() {
        int result = this.myConnectionId;
        result = 31 * result + this.myTopic.hashCode();
        result = 31 * result + this.myType.hashCode();
        result = 31 * result + this.myMd5sum.hashCode();
        result = 31 * result + this.myMessageDefinition.hashCode();
        result = 31 * result + (this.myCallerId != null ? this.myCallerId.hashCode() : 0);
        result = 31 * result + (this.myLatching != null ? this.myLatching.hashCode() : 0);
        return result;
    }
}

