/*
 * Decompiled with CFR 0.152.
 */
package com.github.swrirobotics.bags.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

public class ByteBufferChannel
implements SeekableByteChannel {
    private final ByteBuffer myBuffer;

    public ByteBufferChannel(ByteBuffer buffer) {
        this.myBuffer = buffer;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        byte[] bytes = new byte[byteBuffer.remaining()];
        this.myBuffer.get(bytes);
        byteBuffer.put(bytes);
        return bytes.length;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        byte[] bytes = new byte[this.myBuffer.remaining()];
        byteBuffer.get(bytes);
        this.myBuffer.put(bytes);
        return bytes.length;
    }

    @Override
    public long position() throws IOException {
        return this.myBuffer.position();
    }

    @Override
    public SeekableByteChannel position(long l) throws IOException {
        this.myBuffer.position((int)l);
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.myBuffer.capacity();
    }

    @Override
    public SeekableByteChannel truncate(long l) throws IOException {
        return this;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

