/*
 * Decompiled with CFR 0.152.
 */
package com.github.swrirobotics.bags.reader.messages.serialization;

import com.github.swrirobotics.bags.reader.ByteBufferChannel;
import com.github.swrirobotics.bags.reader.exceptions.BagReaderException;
import com.github.swrirobotics.bags.reader.exceptions.UnknownMessageException;
import com.github.swrirobotics.bags.reader.messages.serialization.MessageType;
import com.github.swrirobotics.bags.reader.records.ChunkInfo;
import com.github.swrirobotics.bags.reader.records.ChunkRecordIterator;
import com.github.swrirobotics.bags.reader.records.Connection;
import com.github.swrirobotics.bags.reader.records.Record;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgIterator
implements Iterator<MessageType> {
    private final SeekableByteChannel myInput;
    private final List<ChunkInfo> myChunkInfos;
    private final Iterator<Connection> myConnections;
    private Connection myCurrentConn = null;
    private ByteBufferChannel currentBuffer = null;
    private ChunkRecordIterator chunkIter = null;
    private MessageType myCurrentConnMt = null;
    private MessageType nextMsg = null;
    private static final Logger myLogger = LoggerFactory.getLogger(MsgIterator.class);

    public MsgIterator(List<ChunkInfo> chunkInfos, Connection connId, SeekableByteChannel input) {
        this(chunkInfos, Lists.newArrayList((Object[])new Connection[]{connId}), input);
    }

    public MsgIterator(List<ChunkInfo> chunkInfos, List<Connection> conns, SeekableByteChannel input) {
        this.myConnections = conns.iterator();
        this.myInput = input;
        this.myChunkInfos = chunkInfos;
    }

    @Override
    public boolean hasNext() {
        if (this.nextMsg == null) {
            this.nextMsg = this.findNext();
        }
        return this.nextMsg != null;
    }

    @Override
    public MessageType next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.nextMsg != null) {
            MessageType tmp = this.nextMsg;
            this.nextMsg = null;
            return tmp;
        }
        throw new NoSuchElementException();
    }

    private MessageType findNext() {
        if (this.currentBuffer == null) {
            if (this.chunkIter != null && this.chunkIter.hasNext()) {
                Record nextChunk = this.chunkIter.next();
                try {
                    this.currentBuffer = new ByteBufferChannel(nextChunk.getData());
                }
                catch (BagReaderException e) {
                    return null;
                }
            }
            if (!this.myConnections.hasNext()) {
                return null;
            }
            this.myCurrentConn = this.myConnections.next();
            try {
                this.myCurrentConnMt = this.myCurrentConn.getMessageCollection().getMessageType();
            }
            catch (UnknownMessageException e) {
                myLogger.error("Unable to deserialize messages for connection " + this.myCurrentConn.getConnectionId());
                return null;
            }
            this.chunkIter = new ChunkRecordIterator(this.myCurrentConn.getConnectionId(), this.myInput, this.myChunkInfos);
            return this.findNext();
        }
        try {
            while (this.currentBuffer.position() < this.currentBuffer.size()) {
                Record record = new Record(this.currentBuffer);
                if (record.getHeader().getType() != Record.RecordType.MESSAGE_DATA || record.getHeader().getInt("conn") != this.myCurrentConn.getConnectionId()) continue;
                this.myCurrentConnMt.reset();
                this.myCurrentConnMt.readMessage(record);
                return this.myCurrentConnMt;
            }
        }
        catch (BagReaderException | IOException | RuntimeException e) {
            myLogger.error("Error reading messages", (Throwable)e);
            return null;
        }
        this.currentBuffer = null;
        return this.findNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

