/*
 * Decompiled with CFR 0.152.
 */
package com.github.swrirobotics.bags.reader.records;

import com.github.swrirobotics.bags.reader.exceptions.BagReaderException;
import com.github.swrirobotics.bags.reader.records.Record;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class ChunkInfo {
    private final int myVersion;
    private final long myChunkPos;
    private final Timestamp myStartTime;
    private final Timestamp myEndTime;
    private final int myCount;
    private final List<ChunkConnection> myConnections = new ArrayList<ChunkConnection>();

    public ChunkInfo(Record record) throws BagReaderException {
        this.myVersion = record.getHeader().getInt("ver");
        this.myChunkPos = record.getHeader().getLong("chunk_pos");
        this.myStartTime = record.getHeader().getTimestamp("start_time");
        this.myEndTime = record.getHeader().getTimestamp("end_time");
        this.myCount = record.getHeader().getInt("count");
        int[] connectionCounts = new int[this.myCount * 2];
        record.getData().asIntBuffer().get(connectionCounts);
        for (int i = 0; i < connectionCounts.length; i += 2) {
            this.myConnections.add(new ChunkConnection(connectionCounts[i], connectionCounts[i + 1]));
        }
    }

    public int getVersion() {
        return this.myVersion;
    }

    public long getChunkPos() {
        return this.myChunkPos;
    }

    public Timestamp getStartTime() {
        return this.myStartTime;
    }

    public Timestamp getEndTime() {
        return this.myEndTime;
    }

    public int getCount() {
        return this.myCount;
    }

    public List<ChunkConnection> getConnections() {
        return this.myConnections;
    }

    public static class ChunkConnection {
        private final int myConnectionId;
        private final int myMessageCount;

        public ChunkConnection(int conn, int count) {
            this.myConnectionId = conn;
            this.myMessageCount = count;
        }

        public int getConnectionId() {
            return this.myConnectionId;
        }

        public int getMessageCount() {
            return this.myMessageCount;
        }
    }
}

