/*
 * Decompiled with CFR 0.152.
 */
package com.reactify;

import com.github.benmanes.caffeine.cache.Cache;
import com.reactify.CacheStore;
import java.util.Objects;
import java.util.Optional;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.interceptor.SimpleKeyGenerator;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ClassUtils;
import reactor.cache.CacheMono;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;

@Aspect
@Configuration
public class CacheAspect {
    private static final Logger log = LoggerFactory.getLogger(CacheAspect.class);

    @Pointcut(value="@annotation(com.reactify.LocalCache)")
    private void processAnnotation() {
    }

    @Around(value="processAnnotation()")
    public Object aroundAdvice(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        Object key = SimpleKeyGenerator.generateKey((Object[])args);
        String name = ClassUtils.getUserClass(joinPoint.getTarget().getClass()).getSimpleName() + "." + joinPoint.getSignature().getName();
        Cache<Object, Object> cache = CacheStore.getCache(name);
        return CacheMono.lookup(k -> Mono.justOrEmpty((Object)cache.getIfPresent(key)).map(Signal::next), (Object)key).onCacheMissResume((Mono)joinPoint.proceed(args)).andWriteWith((k, sig) -> Mono.fromRunnable(() -> {
            if (!(sig == null || sig.get() == null || sig.get() instanceof Optional && ((Optional)Objects.requireNonNull(sig.get())).isEmpty())) {
                cache.put(k, sig.get());
            }
        }));
    }
}

