/*
 * Decompiled with CFR 0.152.
 */
package com.reactify;

import com.reactify.ApplicationContextProvider;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class CacheUtils {
    private static final Logger log = LoggerFactory.getLogger(CacheUtils.class);

    public static void invokeMethod(Method method) {
        try {
            Class<?> declaringClass = method.getDeclaringClass();
            Object t = ApplicationContextProvider.getApplicationContext().getBean(declaringClass);
            Mono rs = (Mono)method.invoke(t, new Object[0]);
            rs.subscribe();
        }
        catch (Exception exception) {
            log.error("Error when autoload cache {}.{}.{}", new Object[]{method.getDeclaringClass().getSimpleName(), method.getName(), exception.getMessage(), exception});
        }
    }
}

