/*
 * Decompiled with CFR 0.152.
 */
package com.reactify;

import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.reactify.CacheUtils;
import java.lang.reflect.Method;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizeRemovalListener
implements RemovalListener<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(CustomizeRemovalListener.class);
    private Method method;

    public void onRemoval(@Nullable Object key, @Nullable Object value, @NonNull RemovalCause removalCause) {
        if (removalCause.wasEvicted()) {
            log.info("Cache {}.{} was evicted because {}", new Object[]{this.method.getDeclaringClass().getSimpleName(), this.method.getName(), removalCause});
            CacheUtils.invokeMethod(this.method);
        }
    }

    public CustomizeRemovalListener(Method method) {
        this.method = method;
    }
}

