/*
 * Decompiled with CFR 0.152.
 */
package com.reactify;

import com.github.benmanes.caffeine.cache.Cache;
import com.reactify.CacheStore;
import com.reactify.DataUtil;
import java.util.Optional;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.interceptor.SimpleKeyGenerator;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ClassUtils;
import reactor.cache.CacheMono;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;

@Aspect
@Configuration
public class CacheAspect {
    private static final Logger log = LoggerFactory.getLogger(CacheAspect.class);

    @Pointcut(value="@annotation(com.reactify.LocalCache)")
    private void processAnnotation() {
    }

    @Around(value="processAnnotation()")
    public Object aroundAdvice(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        Object key = SimpleKeyGenerator.generateKey((Object[])args);
        String nameCache = ClassUtils.getUserClass(joinPoint.getTarget().getClass()).getSimpleName() + "." + joinPoint.getSignature().getName();
        Cache<Object, Object> cache = CacheStore.getCache(nameCache);
        log.debug("Checking cache for method: {} with key: {}", (Object)nameCache, key);
        return CacheMono.lookup(k -> Mono.justOrEmpty((Object)(!DataUtil.isNullOrEmpty((Object)cache) ? cache.getIfPresent(key) : Mono.empty())).map(Signal::next), (Object)key).onCacheMissResume(Mono.defer(() -> {
            try {
                Object result = joinPoint.proceed(args);
                if (!(result instanceof Mono)) {
                    log.warn("Method {} must return a Mono<?> but got: {}", (Object)nameCache, (Object)result.getClass().getSimpleName());
                    return Mono.error((Throwable)new IllegalStateException("Method must return Mono<?>"));
                }
                Mono resultCast = (Mono)result;
                return resultCast;
            }
            catch (Throwable ex) {
                log.error("Execution error in {} - {}", new Object[]{nameCache, ex.getMessage(), ex});
                return Mono.error((Throwable)ex);
            }
        })).andWriteWith((k, sig) -> Mono.fromRunnable(() -> Optional.ofNullable(sig).map(Signal::get).filter(value -> !(value instanceof Optional) || !((Optional)value).isEmpty()).ifPresent(value -> {
            cache.put(k, value);
            log.debug("Cached value for key: {} in method: {}", k, (Object)nameCache);
        })));
    }
}

