/*
 * Decompiled with CFR 0.152.
 */
package com.reactify;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.reactify.CacheUtils;
import com.reactify.CustomizeRemovalListener;
import com.reactify.LocalCache;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class CacheStore
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(CacheStore.class);
    private static final HashMap<String, Cache<Object, Object>> caches = new HashMap();
    private static final Set<Method> autoLoadMethods = new HashSet<Method>();
    private static String reflectionPath;

    @PostConstruct
    private static void init() {
        log.info("=====> Start initializing cache <=====");
        Reflections reflections = new Reflections(reflectionPath, new Scanner[]{Scanners.MethodsAnnotated});
        Set methods = reflections.get(Scanners.MethodsAnnotated.with(new AnnotatedElement[]{LocalCache.class}).as(Method.class, new ClassLoader[0]));
        log.info("Found {} methods annotated with @LocalCache", (Object)methods.size());
        for (Method method : methods) {
            Cache cache;
            String className = method.getDeclaringClass().getSimpleName();
            LocalCache localCache = method.getAnnotation(LocalCache.class);
            int maxRecord = localCache.maxRecord();
            int durationInMinute = localCache.durationInMinute();
            String cacheName = className + "." + method.getName();
            boolean autoLoad = localCache.autoCache();
            if (autoLoad && method.getParameterCount() == 0) {
                cache = Caffeine.newBuilder().scheduler(Scheduler.systemScheduler()).expireAfterWrite(Duration.ofMinutes(durationInMinute)).recordStats().maximumSize((long)maxRecord).removalListener((RemovalListener)new CustomizeRemovalListener(method)).build();
                autoLoadMethods.add(method);
            } else {
                cache = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(durationInMinute)).recordStats().maximumSize((long)maxRecord).build();
            }
            caches.put(cacheName, (Cache<Object, Object>)cache);
        }
        log.info("=====> Finish initializing {} cache <=====", (Object)caches.size());
    }

    public static Cache<Object, Object> getCache(String key) {
        return caches.get(key);
    }

    public static List<String> getCaches() {
        return new ArrayList<String>(caches.keySet());
    }

    public static int clearCachesByName(String cacheName) {
        log.info("Clearing cache: {}", (Object)cacheName);
        return (int)caches.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(cacheName)).peek(entry -> {
            ((Cache)entry.getValue()).invalidateAll();
            log.info("Cache {} cleared", entry.getKey());
        }).count();
    }

    public static int clearAllCaches() {
        log.info("Clearing all caches");
        int count = 0;
        for (Map.Entry<String, Cache<Object, Object>> entry : caches.entrySet()) {
            ++count;
            entry.getValue().invalidateAll();
            log.info("Cleared cache: {}", (Object)entry.getKey());
        }
        return count;
    }

    @Async
    @EventListener
    public void autoLoad(ContextRefreshedEvent event) {
        log.info("Received ContextRefreshedEvent: {}", (Object)event.getApplicationContext());
        if (!autoLoadMethods.isEmpty()) {
            log.info("=====> Start auto-loading {} caches <=====", (Object)autoLoadMethods.size());
            for (Method method : autoLoadMethods) {
                CacheUtils.invokeMethod(method);
                log.info("Auto-loaded cache for method: {}", (Object)method.getName());
            }
            log.info("=====> Finished auto-loading caches <=====");
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Class<?> mainApplicationClass = applicationContext.getBeansWithAnnotation(SpringBootApplication.class).values().iterator().next().getClass();
        reflectionPath = mainApplicationClass.getPackageName();
        log.info("Set reflection path for cache scanning: {}", (Object)reflectionPath);
    }
}

