/*
 * Decompiled with CFR 0.152.
 */
package com.reactify;

import com.reactify.ApplicationContextProvider;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class CacheUtils {
    private static final Logger log = LoggerFactory.getLogger(CacheUtils.class);

    public static void invokeMethod(Method method) {
        try {
            Class<?> declaringClass = method.getDeclaringClass();
            Object beanInstance = ApplicationContextProvider.getBean(declaringClass);
            Object result = method.invoke(beanInstance, new Object[0]);
            String methodName = declaringClass.getSimpleName() + "." + method.getName();
            if (result instanceof Mono) {
                Mono monoResult = (Mono)result;
                monoResult.subscribe(success -> log.debug("Successfully executed {}", (Object)methodName), error -> log.error("Error executing {}", (Object)methodName, error));
            } else {
                log.warn("Method {} does not return a Mono<?>", (Object)methodName);
            }
        }
        catch (IllegalAccessException e) {
            log.error("Access violation when invoking method {}: {}", new Object[]{method.getName(), e.getMessage(), e});
        }
        catch (Exception e) {
            log.error("Error when autoload cache {}.{}.{}", new Object[]{method.getDeclaringClass().getSimpleName(), method.getName(), e.getMessage(), e});
        }
    }
}

