/*
 * Decompiled with CFR 0.152.
 */
package com.reactify;

import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.reactify.CacheUtils;
import java.lang.reflect.Method;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizeRemovalListener
implements RemovalListener<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(CustomizeRemovalListener.class);
    private final Method method;

    public CustomizeRemovalListener(Method method) {
        this.method = method;
    }

    public void onRemoval(@Nullable Object key, @Nullable Object value, @NonNull RemovalCause removalCause) {
        if (!removalCause.wasEvicted()) {
            return;
        }
        String methodName = this.method.getDeclaringClass().getSimpleName() + "." + this.method.getName();
        log.info("Cache {} was evicted due to {}", (Object)methodName, (Object)removalCause);
        CacheUtils.invokeMethod(this.method);
    }
}

