/*
 * Decompiled with CFR 0.152.
 */
package com.reactify;

import com.reactify.DataUtil;
import com.reactify.filter.properties.ProxyProperties;
import com.reactify.filter.properties.WebClientProperties;
import com.reactify.filter.webclient.WebClientLoggingFilter;
import com.reactify.filter.webclient.WebClientRetryHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.transport.ProxyProvider;

public class WebClientFactory
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(WebClientFactory.class);
    @Autowired
    private ApplicationContext applicationContext;
    private final List<WebClientProperties> webClients;

    public WebClientFactory(List<WebClientProperties> webClients) {
        this.webClients = webClients;
    }

    public void afterPropertiesSet() {
        this.initWebClients(this.webClients);
    }

    public void initWebClients(List<WebClientProperties> webClients) {
        ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory();
        for (WebClientProperties webClientProperties : webClients) {
            WebClient webClient = this.createNewClient(webClientProperties);
            if (webClient == null) continue;
            beanFactory.registerSingleton(webClientProperties.getName(), (Object)webClient);
        }
    }

    public WebClient createNewClient(WebClientProperties webClientProperties) {
        List<ExchangeFilterFunction> customFilters;
        if (!this.isValidProperties(webClientProperties)) {
            log.error("Failed to setup a webClientProperties {}", (Object)webClientProperties.getName());
            return null;
        }
        ConnectionProvider connectionProvider = ((ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder((String)(webClientProperties.getName() + "Pool")).maxConnections(webClientProperties.getPool().getMaxSize().intValue())).pendingAcquireMaxCount(webClientProperties.getPool().getMaxPendingAcquire().intValue())).build();
        HttpClient httpClient = (HttpClient)((HttpClient)((HttpClient)((HttpClient)((HttpClient)HttpClient.create((ConnectionProvider)connectionProvider).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)webClientProperties.getTimeout().getConnection())).responseTimeout(Duration.ofMillis(webClientProperties.getTimeout().getRead())).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(EpollChannelOption.TCP_KEEPIDLE, (Object)300)).option(EpollChannelOption.TCP_KEEPINTVL, (Object)60)).option(EpollChannelOption.TCP_KEEPCNT, (Object)8);
        ExchangeStrategies strategies = ExchangeStrategies.builder().codecs(configurer -> {
            configurer.registerDefaults(true);
            configurer.defaultCodecs().maxInMemorySize(0x4000000);
        }).build();
        WebClient.Builder exchangeStrategies = WebClient.builder().baseUrl(webClientProperties.getAddress()).exchangeStrategies(strategies);
        if (!DataUtil.isNullOrEmpty((CharSequence)webClientProperties.getUsername())) {
            exchangeStrategies.defaultHeader("Authorization", new String[]{"Bearer " + Base64.getEncoder().encodeToString((webClientProperties.getUsername() + ":" + webClientProperties.getPassword()).getBytes(StandardCharsets.UTF_8))});
        }
        if (webClientProperties.getLog().isEnable()) {
            exchangeStrategies.filter((ExchangeFilterFunction)new WebClientLoggingFilter(webClientProperties.getLog().getObfuscateHeaders()));
        }
        if (webClientProperties.getRetry().isEnable()) {
            exchangeStrategies.filter((ExchangeFilterFunction)new WebClientRetryHandler(webClientProperties.getRetry()));
        }
        if (webClientProperties.getProxy().isEnable()) {
            httpClient = this.configProxy(httpClient, webClientProperties.getProxy());
        }
        if ((customFilters = webClientProperties.getCustomFilters()) != null) {
            for (ExchangeFilterFunction filter : customFilters) {
                exchangeStrategies.filter(filter);
            }
        }
        log.info("Success setup client properties {}", (Object)webClientProperties.getName());
        ReactorClientHttpConnector clientConnector = new ReactorClientHttpConnector(httpClient);
        return exchangeStrategies.clientConnector((ClientHttpConnector)clientConnector).build();
    }

    private HttpClient configProxy(HttpClient httpClient, ProxyProperties proxyConfig) {
        String httpHost = proxyConfig.getHttpHost();
        Integer httpPort = proxyConfig.getHttpPort();
        String httpsHost = proxyConfig.getHttpsHost();
        Integer httpsPort = proxyConfig.getHttpsPort();
        if (!DataUtil.isNullOrEmpty((CharSequence)httpHost) && !DataUtil.isNullOrEmpty((Object)httpPort)) {
            httpClient = (HttpClient)httpClient.proxy(proxy -> proxy.type(ProxyProvider.Proxy.HTTP).host(httpHost).port(httpPort.intValue()));
        }
        if (!DataUtil.isNullOrEmpty((CharSequence)httpsHost) && !DataUtil.isNullOrEmpty((Object)httpsPort)) {
            SslContext sslContext;
            try {
                sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            }
            catch (Exception ex) {
                return httpClient;
            }
            httpClient = ((HttpClient)httpClient.proxy(proxy -> proxy.type(ProxyProvider.Proxy.HTTP).host(httpsHost).port(httpsPort.intValue()))).secure(t -> t.sslContext(sslContext));
        }
        return httpClient;
    }

    private boolean isValidProperties(WebClientProperties webClientProperties) {
        return !DataUtil.isNullOrEmpty((CharSequence)webClientProperties.getName()) && !DataUtil.isNullOrEmpty((CharSequence)webClientProperties.getAddress());
    }
}

