/*
 * Decompiled with CFR 0.152.
 */
package com.reactify.exception;

import java.util.Arrays;
import java.util.Objects;

public class BusinessException
extends RuntimeException {
    private final String errorCode;
    private final String message;
    private Object[] paramsMsg;

    public BusinessException(String errorCode, String message) {
        this.errorCode = errorCode;
        this.message = message;
    }

    public BusinessException(String errorCode, String message, String ... paramsMsg) {
        this.errorCode = errorCode;
        this.paramsMsg = Arrays.stream(paramsMsg).toArray(String[]::new);
        this.message = message;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public Object[] getParamsMsg() {
        return this.paramsMsg;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BusinessException)) {
            return false;
        }
        BusinessException that = (BusinessException)o;
        return Objects.equals(this.getErrorCode(), that.getErrorCode()) && Objects.equals(this.getMessage(), that.getMessage()) && Arrays.equals(this.getParamsMsg(), that.getParamsMsg());
    }

    public int hashCode() {
        int result = Objects.hash(this.getErrorCode(), this.getMessage());
        result = 31 * result + Arrays.hashCode(this.getParamsMsg());
        return result;
    }
}

