/*
 * Decompiled with CFR 0.152.
 */
package com.reactify.filter.webclient;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class WebClientLoggingFilter
implements ExchangeFilterFunction {
    private static final Logger log = LoggerFactory.getLogger(WebClientLoggingFilter.class);
    private final List<String> obfuscateHeader;
    private static final String OBFUSCATE_HEADER = "xxxxx";

    public WebClientLoggingFilter(List<String> obfuscateHeader) {
        this.obfuscateHeader = obfuscateHeader;
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        log.info("Start Call API - Method: {} {}", (Object)request.method(), (Object)request.url());
        if (request.headers().getContentLength() > 0L) {
            log.info("body {}", (Object)request.body());
        }
        if (log.isDebugEnabled()) {
            request.headers().forEach((name, values) -> values.forEach(value -> log.debug("Request header: {}={}", name, (Object)(this.obfuscateHeader.contains(name) ? OBFUSCATE_HEADER : value))));
        }
        return next.exchange(request).flatMap(clientResponse -> {
            if (log.isDebugEnabled()) {
                clientResponse.headers().asHttpHeaders().forEach((name, values) -> values.forEach(value -> log.debug("Response header: {}={}", name, (Object)(this.obfuscateHeader.contains(name) ? OBFUSCATE_HEADER : value))));
            }
            return Mono.just((Object)clientResponse);
        });
    }
}

