/*
 * Decompiled with CFR 0.152.
 */
package com.reactify.filter.webclient;

import com.reactify.filter.properties.RetryProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NestedExceptionUtils;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetrySpec;

public class WebClientRetryHandler
implements ExchangeFilterFunction {
    private static final Logger log = LoggerFactory.getLogger(WebClientRetryHandler.class);
    private final RetryProperties properties;

    public WebClientRetryHandler(RetryProperties properties) {
        this.properties = properties;
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        RetrySpec retry = Retry.max((long)this.properties.getCount()).filter(e -> this.properties.getMethods().contains(request.method()) && this.properties.getExceptions().stream().anyMatch(clazz -> clazz.isInstance(e) || clazz.isInstance(NestedExceptionUtils.getRootCause((Throwable)e)))).doBeforeRetry(retrySignal -> log.warn("Retrying: {}; Cause: {}.", (Object)retrySignal.totalRetries(), (Object)retrySignal.failure())).onRetryExhaustedThrow((retrySpec, retrySignal) -> retrySignal.failure());
        return next.exchange(request).retryWhen((Retry)retry);
    }
}

