/*
 * Decompiled with CFR 0.152.
 */
package com.reactify.impl;

import com.reactify.BaseRestClient;
import com.reactify.DataUtil;
import com.reactify.ObjectMapperUtil;
import com.reactify.exception.BusinessException;
import io.netty.channel.ChannelOption;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.transport.ProxyProvider;

@Service
public class BaseRestClientImpl<T>
implements BaseRestClient<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseRestClientImpl.class);

    @Override
    public Mono<Optional<T>> get(WebClient webClient, String url, MultiValueMap<String, String> headerMap, MultiValueMap<String, String> payload, Class<?> resultClass) {
        log.info("Rest service payload client: {}", payload);
        return webClient.get().uri(uriBuilder -> uriBuilder.path(url).queryParams(this.getSafePayload(payload)).build(new Object[0])).headers(httpHeaders -> httpHeaders.addAll(this.getSafeRestHeader(headerMap))).retrieve().bodyToMono(String.class).map(response -> {
            log.info("Rest response {}", response);
            if (DataUtil.isNullOrEmpty((CharSequence)response)) {
                return Optional.empty();
            }
            if (DataUtil.safeEqual((String)resultClass.getSimpleName(), (String)"String")) {
                String result = response;
                return Optional.of(result);
            }
            Object result = DataUtil.parseStringToObject((String)response, (Class)resultClass);
            return Optional.ofNullable(result);
        }).onErrorResume(WebClientResponseException.class, e -> {
            log.error("Exception call get rest api: ", (Throwable)e);
            String responseError = e.getResponseBodyAsString(StandardCharsets.UTF_8);
            Object result = DataUtil.parseStringToObject((String)responseError, (Class)resultClass);
            return Mono.just(Optional.ofNullable(result));
        });
    }

    @Override
    public Mono<String> getRaw(WebClient webClient, String url, MultiValueMap<String, String> headerMap, MultiValueMap<String, String> payload) {
        return webClient.get().uri(uriBuilder -> uriBuilder.path(url).queryParams(this.getSafePayload(payload)).build(new Object[0])).headers(httpHeaders -> httpHeaders.addAll(this.getSafeRestHeader(headerMap))).retrieve().bodyToMono(String.class).map(DataUtil::safeToString).onErrorResume(WebClientResponseException.class, e -> {
            log.error("call rest api ", (Throwable)e);
            return Mono.just((Object)"");
        });
    }

    @Override
    public Mono<Optional<T>> post(WebClient webClient, String url, MultiValueMap<String, String> headerList, Object payload, Class<?> resultClass) {
        if (DataUtil.isNullOrEmpty((Object)payload)) {
            payload = new LinkedMultiValueMap();
        }
        log.info("Payload when calling post: {}", payload);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)webClient.post().uri(url, new Object[0])).headers(httpHeaders -> httpHeaders.addAll(this.getSafeRestHeader(headerList)))).bodyValue(payload).retrieve().onStatus(HttpStatusCode::isError, BaseRestClientImpl::handleErrorResponse).bodyToMono(String.class).map(response -> this.processReturn((String)response, resultClass)).onErrorResume(WebClientResponseException.class, e -> {
            log.error("call post rest api error: ", (Throwable)e);
            String responseError = e.getResponseBodyAsString(StandardCharsets.UTF_8);
            Object result = DataUtil.parseStringToObject((String)responseError, (Class)resultClass);
            return Mono.just(Optional.ofNullable(result));
        });
    }

    @Override
    public Mono<Optional<T>> postFormData(WebClient webClient, String url, MultiValueMap<String, String> headerList, MultiValueMap<String, String> formData, Class<?> resultClass) {
        if (formData == null) {
            formData = new LinkedMultiValueMap();
        }
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)webClient.post().uri(url, new Object[0])).headers(httpHeaders -> httpHeaders.addAll(this.getSafeRestHeader(headerList)))).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((BodyInserter)BodyInserters.fromFormData((MultiValueMap)formData)).retrieve().bodyToMono(String.class).map(response -> this.processReturn((String)response, resultClass)).onErrorResume(WebClientResponseException.class, e -> {
            log.error("call post rest api: ", (Throwable)e);
            String responseError = e.getResponseBodyAsString(StandardCharsets.UTF_8);
            Object result = DataUtil.parseStringToObject((String)responseError, (Class)resultClass);
            return Mono.just(Optional.ofNullable(result));
        });
    }

    @Override
    public Optional<T> processReturn(String response, Class<?> resultClass) {
        if (DataUtil.isNullOrEmpty((CharSequence)response)) {
            return Optional.empty();
        }
        Object result = DataUtil.parseStringToObject((String)response, resultClass);
        return Optional.ofNullable(result);
    }

    @Override
    public Mono<Optional<T>> delete(WebClient webClient, String url, MultiValueMap<String, String> headerList, MultiValueMap<String, String> payload, Class<?> resultClass) {
        return webClient.delete().uri(uriBuilder -> uriBuilder.path(url).queryParams(this.getSafePayload(payload)).build(new Object[0])).headers(httpHeaders -> httpHeaders.addAll(this.getSafeRestHeader(headerList))).retrieve().bodyToMono(String.class).map(response -> this.processReturn((String)response, resultClass)).onErrorResume(WebClientResponseException.class, e -> {
            log.error("call delete rest api: ", (Throwable)e);
            String responseError = e.getResponseBodyAsString(StandardCharsets.UTF_8);
            Object result = DataUtil.parseStringToObject((String)responseError, (Class)resultClass);
            return Mono.just(Optional.ofNullable(result));
        });
    }

    private MultiValueMap<String, String> getSafePayload(MultiValueMap<String, String> payload) {
        return !DataUtil.isNullOrEmpty(payload) ? payload : new LinkedMultiValueMap();
    }

    @Override
    public Mono<String> callApiCertificateFileService(WebClient webClient, String url, MultiValueMap<String, String> headerList, Object payload, Class<?> resultClass) {
        if (DataUtil.isNullOrEmpty((Object)payload)) {
            payload = new LinkedMultiValueMap();
        }
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)webClient.post().uri(url, new Object[0])).headers(httpHeaders -> httpHeaders.addAll(this.getSafeRestHeader(headerList)))).bodyValue(payload).retrieve().onStatus(HttpStatusCode::isError, BaseRestClientImpl::handleErrorResponse).bodyToMono(String.class).map(response -> response).onErrorResume(WebClientResponseException.class, e -> {
            log.error("call post rest api: ", (Throwable)e);
            String responseError = e.getResponseBodyAsString(StandardCharsets.UTF_8);
            return Mono.just((Object)responseError);
        });
    }

    @Override
    public Mono<Optional<T>> callPostBodyJson(WebClient webClient, String url, MultiValueMap<String, String> headerList, Object payload, Class<?> resultClass) {
        if (DataUtil.isNullOrEmpty((Object)payload)) {
            payload = new LinkedMultiValueMap();
        }
        log.info("payload when call post {}", payload);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)webClient.post().uri(url, new Object[0])).headers(httpHeaders -> httpHeaders.addAll(this.getSafeRestHeader(headerList)))).bodyValue((Object)Objects.requireNonNull(ObjectMapperUtil.convertObjectToJson((Object)payload))).retrieve().onStatus(HttpStatusCode::isError, BaseRestClientImpl::handleErrorResponse).bodyToMono(String.class).map(response -> this.processReturn((String)response, resultClass)).onErrorResume(WebClientResponseException.class, e -> {
            log.error("call post rest api: ", (Throwable)e);
            String responseError = e.getResponseBodyAsString(StandardCharsets.UTF_8);
            Object result = DataUtil.parseStringToObject((String)responseError, (Class)resultClass);
            return Mono.just(Optional.ofNullable(result));
        });
    }

    @Override
    public WebClient proxyClient(String proxyHost, Integer proxyPort, Boolean proxyEnable) {
        ConnectionProvider connectionProvider = ((ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder((String)"Rest-client-Pool").maxConnections(2000)).pendingAcquireMaxCount(2000)).build();
        HttpClient httpClient = (HttpClient)((HttpClient)((HttpClient)((HttpClient)((HttpClient)HttpClient.create((ConnectionProvider)connectionProvider).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)1000)).responseTimeout(Duration.ofMillis(10000L)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(EpollChannelOption.TCP_KEEPIDLE, (Object)300)).option(EpollChannelOption.TCP_KEEPINTVL, (Object)60)).option(EpollChannelOption.TCP_KEEPCNT, (Object)8);
        if (proxyEnable.booleanValue()) {
            SslContext sslContext;
            try {
                sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            }
            catch (Exception ex) {
                return null;
            }
            httpClient = ((HttpClient)httpClient.proxy(proxy -> proxy.type(ProxyProvider.Proxy.HTTP).host(proxyHost).port(proxyPort.intValue()))).secure(t -> t.sslContext(sslContext));
        }
        ReactorClientHttpConnector clientConnector = new ReactorClientHttpConnector(httpClient);
        return WebClient.builder().codecs(clientCodecConfigurer -> clientCodecConfigurer.defaultCodecs().maxInMemorySize(0x1000000)).clientConnector((ClientHttpConnector)clientConnector).build();
    }

    @Override
    public WebClient proxyHttpClient(String proxyHost, Integer proxyPort) {
        HttpClient httpClient = (HttpClient)HttpClient.create().proxy(proxy -> proxy.type(ProxyProvider.Proxy.HTTP).host(proxyHost).port(proxyPort.intValue()));
        ReactorClientHttpConnector connector = new ReactorClientHttpConnector(httpClient);
        return WebClient.builder().clientConnector((ClientHttpConnector)connector).defaultHeader("Content-Type", new String[]{"application/x-www-form-urlencoded"}).build();
    }

    @Override
    public Mono<Optional<T>> callPostBodyJsonForLocalDateTime(WebClient webClient, String url, MultiValueMap<String, String> headerList, Object payload, Class<?> resultClass) {
        if (DataUtil.isNullOrEmpty((Object)payload)) {
            payload = new LinkedMultiValueMap();
        }
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)webClient.post().uri(url, new Object[0])).headers(httpHeaders -> httpHeaders.addAll(this.getSafeRestHeader(headerList)))).bodyValue((Object)Objects.requireNonNull(ObjectMapperUtil.convertObjectToJsonForLocalDateTime((Object)payload))).retrieve().onStatus(HttpStatusCode::isError, BaseRestClientImpl::handleErrorResponse).bodyToMono(String.class).map(response -> this.processReturn((String)response, resultClass)).onErrorResume(WebClientResponseException.class, e -> {
            log.error("call post rest api: ", (Throwable)e);
            String responseError = e.getResponseBodyAsString(StandardCharsets.UTF_8);
            Object result = DataUtil.parseStringToObject((String)responseError, (Class)resultClass);
            return Mono.just(Optional.ofNullable(result));
        });
    }

    @Override
    public Mono<String> postRawBodyJson(WebClient webClient, String url, MultiValueMap<String, String> headerList, Object payload) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)webClient.post().uri(url, new Object[0])).headers(httpHeaders -> httpHeaders.addAll(this.getSafeRestHeader(headerList)))).bodyValue((Object)Objects.requireNonNull(ObjectMapperUtil.convertObjectToJson((Object)payload))).retrieve().onStatus(HttpStatusCode::isError, BaseRestClientImpl::handleErrorResponse).bodyToMono(String.class).map(DataUtil::safeToString).onErrorResume(WebClientResponseException.class, e -> {
            log.error("call rest api ", (Throwable)e);
            return Mono.just((Object)"");
        });
    }

    @Override
    public Mono<String> getRawWithFixedUri(WebClient webClient, String uri, MultiValueMap<String, String> headerMap) {
        return webClient.get().uri(uri, new Object[0]).headers(httpHeaders -> httpHeaders.addAll(this.getSafeRestHeader(headerMap))).retrieve().bodyToMono(String.class).map(DataUtil::safeToString).onErrorResume(WebClientResponseException.class, e -> {
            log.error("call rest api ", (Throwable)e);
            return Mono.just((Object)"");
        });
    }

    private MultiValueMap<String, String> getSafeRestHeader(MultiValueMap<String, String> headerMap) {
        if (!DataUtil.isNullOrEmpty(headerMap)) {
            return headerMap;
        }
        headerMap = new LinkedMultiValueMap();
        headerMap.set((Object)"Content-Type", (Object)"application/json");
        return headerMap;
    }

    public static Mono<? extends Throwable> handleErrorResponse(ClientResponse response) {
        return response.bodyToMono(String.class).flatMap(errorBody -> {
            log.info("log when call error {}", errorBody);
            return Mono.error((Throwable)new BusinessException("internal_error", (String)errorBody));
        });
    }
}

