/*
 * Decompiled with CFR 0.152.
 */
package com.reactify.impl;

import com.reactify.BaseSoapClient;
import com.reactify.DataUtil;
import com.reactify.DataWsUtil;
import com.reactify.constants.Constants;
import com.reactify.exception.BusinessException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class BaseSoapClientImpl<T>
implements BaseSoapClient<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseSoapClientImpl.class);

    @Override
    public Mono<Optional<T>> call(WebClient webClient, Map<String, String> headerList, String payload, Class<?> resultClass) {
        log.info("Soap service payload client: {}", (Object)payload);
        MultiValueMap<String, String> header = this.getHeaderForCallSoap(headerList);
        return ((WebClient.RequestBodySpec)webClient.post().headers(httpHeaders -> httpHeaders.addAll(header))).bodyValue((Object)payload).retrieve().onStatus(HttpStatusCode::isError, BaseSoapClientImpl::handleErrorResponse).bodyToMono(String.class).map(response -> {
            String t;
            log.info("Soap Response {}", response);
            if (DataUtil.isNullOrEmpty((CharSequence)response)) {
                return Optional.empty();
            }
            log.info("callRaw soap WS resp: {}", response);
            String formattedSOAPResponse = DataWsUtil.formatXML((String)response);
            String realData = DataWsUtil.getDataByTag((String)formattedSOAPResponse.replaceAll("&lt;", "<").replaceAll("&gt;", ">"), (String)"<return>", (String)"</return>");
            if (DataUtil.isNullOrEmpty((CharSequence)realData)) {
                return Optional.empty();
            }
            String result = DataUtil.safeEqual((String)resultClass.getSimpleName(), (String)"String") ? (t = realData) : this.parseData(realData, resultClass);
            if (result == null) {
                log.error("Exception when parse data");
                return Optional.empty();
            }
            return Optional.of(result);
        }).doOnError(err -> log.error("Call error when use method framework call", err));
    }

    @Override
    public Mono<String> callRaw(WebClient webClient, Map<String, String> headerList, String payload) {
        log.info("Soap service payload client: {}", (Object)payload);
        MultiValueMap<String, String> header = this.getHeaderForCallSoap(headerList);
        return ((WebClient.RequestBodySpec)webClient.post().headers(httpHeaders -> httpHeaders.addAll(header))).bodyValue((Object)payload).retrieve().onStatus(HttpStatusCode::isError, BaseSoapClientImpl::handleErrorResponse).onStatus(Objects::nonNull, clientResponse -> {
            log.info("Status code {}", (Object)clientResponse.statusCode());
            log.info("Full {}", clientResponse);
            return Mono.empty();
        }).bodyToMono(String.class).switchIfEmpty(Mono.error((Throwable)new BusinessException("Call raw", "null"))).map(response -> {
            log.info("callRaw soap WS resp: {}", response);
            return DataUtil.safeToString((Object)response);
        }).log();
    }

    public static Mono<Throwable> handleErrorResponse(ClientResponse response) {
        return response.bodyToMono(String.class).flatMap(errorBody -> {
            log.info("log when call error {}", errorBody);
            return Mono.error((Throwable)new BusinessException("internal_error", (String)errorBody));
        });
    }

    public T parseData(String realData, Class<?> clz) {
        return (T)DataWsUtil.xmlToObj((String)("<return>" + realData + "</return>"), clz);
    }

    private MultiValueMap<String, String> getHeaderForCallSoap(Map<String, String> headerList) {
        LinkedMultiValueMap header = new LinkedMultiValueMap();
        if (DataUtil.isNullOrEmpty(headerList)) {
            header.set((Object)"Content-Type", (Object)"text/xml");
            header.set((Object)"X-B3-TRACEID", (Object)Constants.SoapHeaderConstant.X_B3_TRACEID_VALUE_SOAP);
        } else {
            header.setAll(headerList);
        }
        return header;
    }
}

