/*
 * Decompiled with CFR 0.152.
 */
package com.reactify;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.reactify.ObjectMapperFactory;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class DataUtil {
    private static final Logger log = LoggerFactory.getLogger(DataUtil.class);

    public static boolean isNullOrEmpty(Object ob) {
        return ob == null || ob.toString().trim().isEmpty();
    }

    public static boolean isNullOrEmpty(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(Object[] collection) {
        return collection == null || collection.length == 0;
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static String safeToString(Object obj, String defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        return obj.toString();
    }

    public static String safeToString(Object obj) {
        return DataUtil.safeToString(obj, "");
    }

    public static int safeToInt(Object obj1, int defaultValue) {
        int result = defaultValue;
        if (obj1 != null) {
            try {
                result = Integer.parseInt(obj1.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static int safeToInt(Object obj1) {
        return DataUtil.safeToInt(obj1, 0);
    }

    public static Boolean safeToBoolean(Object obj1) {
        Boolean result = null;
        try {
            result = obj1 == null ? null : (Boolean)obj1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Long safeToLong(Object obj1, Long defaultValue) {
        Long result = defaultValue;
        if (obj1 != null) {
            Object object = obj1;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BigDecimal.class, BigInteger.class, Double.class}, (Object)object2, n)) {
                case 0: {
                    BigDecimal bigDecimal = (BigDecimal)object2;
                    return bigDecimal.longValue();
                }
                case 1: {
                    BigInteger bigInteger = (BigInteger)object2;
                    return bigInteger.longValue();
                }
                case 2: {
                    Double v = (Double)object2;
                    return v.longValue();
                }
            }
            try {
                result = Long.parseLong(obj1.toString());
            }
            catch (Exception ignored) {
                return 1L;
            }
        }
        return result;
    }

    public static Long safeToLong(Object obj1) {
        return DataUtil.safeToLong(obj1, 0L);
    }

    public static Double safeToDouble(Object obj, Double defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(obj.toString());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static Double safeToDouble(Object obj) {
        return DataUtil.safeToDouble(obj, 0.0);
    }

    public static UUID safeToUUID(String input) {
        try {
            return UUID.fromString(input);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean isUUID(String input) {
        try {
            UUID uuid = UUID.fromString(input);
            return uuid.toString().equals(input);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String safeTrim(Object input) {
        return DataUtil.safeToString(input).trim();
    }

    public static String safeTrim(String input) {
        return DataUtil.safeToString(input).trim();
    }

    public static boolean safeEqual(Object obj1, Object obj2) {
        return obj1 != null && obj2 != null && obj2.toString().equals(obj1.toString());
    }

    public static boolean safeEqual(String obj1, String obj2) {
        return Objects.equals(obj1, obj2);
    }

    public static ObjectMapper convertObject() {
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new JavaTimeModule())).propertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE)).configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();
    }

    public static boolean isTrue(Object obj) {
        return DataUtil.safeEqual(DataUtil.safeToString(obj), "true");
    }

    public static <T> T parseStringToObject(String content, Class<?> clz) {
        if (DataUtil.isNullOrEmpty(content)) {
            return null;
        }
        try {
            Object result = ObjectMapperFactory.getInstance().readValue(DataUtil.safeToString(content), clz);
            return (T)result;
        }
        catch (JsonProcessingException result) {
            try {
                return (T)clz.newInstance();
            }
            catch (Exception e) {
                return (T)new Object();
            }
        }
    }

    public static <T> T parseStringToObject(String content, TypeReference<T> clz, T defaultValue) {
        if (DataUtil.isNullOrEmpty(content)) {
            return null;
        }
        try {
            return (T)ObjectMapperFactory.getInstance().readValue(DataUtil.safeToString(content), clz);
        }
        catch (JsonProcessingException e) {
            return defaultValue;
        }
    }

    public static String parseObjectToString(Object obj) {
        if (obj == null) {
            return "";
        }
        try {
            return ObjectMapperFactory.getInstance().writeValueAsString(obj);
        }
        catch (JsonProcessingException ex) {
            return "";
        }
    }

    public static LocalDateTime convertStringToLocalDateTime(String input, String format) {
        if (DataUtil.isNullOrEmpty(input)) {
            return null;
        }
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
            return LocalDateTime.parse(input, formatter);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String formatDate(TemporalAccessor date, String format, String fallbackValue) {
        if (DataUtil.isNullOrEmpty(date)) {
            return fallbackValue;
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern(format);
        return df.format(date);
    }

    public static String sumListString(String ... list) {
        StringBuilder result = new StringBuilder();
        for (String str : list) {
            result.append(str);
        }
        return result.toString();
    }

    public static String getLikeStr(String str) {
        if (str == null) {
            str = "";
        }
        return "%" + str + "%";
    }

    public static boolean isValidFormatJson(String json) {
        if (DataUtil.isNullOrEmpty(json)) {
            log.info("JSON input is null or empty.");
            return false;
        }
        try {
            ObjectMapperFactory.getInstance().readTree(json);
            return true;
        }
        catch (JsonProcessingException e) {
            log.info(e.getMessage());
            return false;
        }
    }

    public static String convertLocalDateToString(LocalDateTime date, String format) {
        try {
            if (ObjectUtils.isEmpty((Object)date)) {
                return null;
            }
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
            return date.format(formatter);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static LocalDateTime convertStringToDateTime(String dateString) {
        try {
            DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
            LocalDate date = LocalDate.parse(dateString, dateFormatter);
            LocalTime time = LocalTime.MIDNIGHT;
            return LocalDateTime.of(date, time);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String appendLikeQuery(String field) {
        return "%" + field + "%";
    }

    public static String convertDocumentToString(Document doc) {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            return writer.getBuffer().toString();
        }
        catch (TransformerException e) {
            return null;
        }
    }

    public static Document convertStringToDocument(String xmlStr) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        InputSource inputSource = new InputSource(new StringReader(xmlStr));
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(inputSource);
    }

    public static Float safeToFloat(Object obj1) {
        return DataUtil.safeToFloat(obj1, Float.valueOf(0.0f));
    }

    public static Float safeToFloat(Object obj1, Float defaultValue) {
        Float result = defaultValue;
        if (obj1 != null) {
            Object object = obj1;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BigDecimal.class, BigInteger.class, Double.class}, (Object)object2, n)) {
                case 0: {
                    BigDecimal bigDecimal = (BigDecimal)object2;
                    return Float.valueOf(bigDecimal.floatValue());
                }
                case 1: {
                    BigInteger bigInteger = (BigInteger)object2;
                    return Float.valueOf(bigInteger.floatValue());
                }
                case 2: {
                    Double v = (Double)object2;
                    return Float.valueOf(v.floatValue());
                }
            }
            try {
                result = Float.valueOf(Float.parseFloat(obj1.toString()));
            }
            catch (Exception ignored) {
                return Float.valueOf(Float.parseFloat("-1"));
            }
        }
        return result;
    }

    public static int validatePageSize(Integer pageSize, int defaultPageSize) {
        if (pageSize == null) {
            pageSize = defaultPageSize;
        } else if (pageSize <= 0) {
            return -1;
        }
        return pageSize;
    }

    public static int validatePageIndex(Integer pageIndex, Integer pageSize) {
        if (pageIndex == null || pageIndex < 1) {
            return 0;
        }
        if (pageSize == null || pageSize <= 0) {
            throw new IllegalArgumentException("Page size must be greater than 0");
        }
        return (pageIndex - 1) * pageSize;
    }

    public static LocalDateTime convertDateStrToLocalDateTime(String input, String format) {
        if (DataUtil.isNullOrEmpty(input) || DataUtil.isNullOrEmpty(format)) {
            return null;
        }
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(format);
        DateTimeFormatter convertDateFormatter = new DateTimeFormatterBuilder().append(dateFormatter).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter();
        try {
            return LocalDateTime.parse(input, convertDateFormatter);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String convertDate2yyyyMMddStringNoSlash(Date value) {
        if (value != null) {
            SimpleDateFormat yyyymm = new SimpleDateFormat("yyyyMMdd");
            return yyyymm.format(value);
        }
        return "";
    }
}

