/*
 * Decompiled with CFR 0.152.
 */
package com.reactify;

import com.reactify.DataUtil;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class DataWsUtil {
    private static final Logger log = LoggerFactory.getLogger(DataWsUtil.class);
    private static final Map<Class<?>, Unmarshaller> instance = new HashMap();

    public static String getDataByTag(String realData, String fromKey, String toKey) {
        String data = "";
        if (!DataUtil.isNullOrEmpty(fromKey) && !DataUtil.isNullOrEmpty(realData) && realData.contains(fromKey) && (DataUtil.isNullOrEmpty(data = realData.substring(realData.indexOf(fromKey) + fromKey.length(), realData.indexOf(toKey))) || DataUtil.safeEqual(data, "N/A"))) {
            data = "";
        }
        return data;
    }

    public static String wrapTag(String data, String openTag, String closeTag) {
        if (DataUtil.isNullOrEmpty(openTag) || DataUtil.isNullOrEmpty(closeTag) || DataUtil.isNullOrEmpty(data)) {
            return "";
        }
        return openTag + data + closeTag;
    }

    public static String wrapTagReturn(String data) {
        return DataWsUtil.wrapTag(data, "<return>", "<return>");
    }

    public static <T> T xmlToObj(String xml, Class<?> clz) {
        try {
            StringReader reader = new StringReader(xml.trim());
            return (T)DataWsUtil.getInstance(clz).unmarshal((Reader)reader);
        }
        catch (Exception ex) {
            log.error("Parse data error {}  :", (Object)(clz.getName() + ex.getMessage()), (Object)ex);
            return null;
        }
    }

    public static Document parseXmlFile(String in) throws Exception {
        try {
            DocumentBuilderFactory dbf = DataWsUtil.getDocumentBuilderFactory();
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(in));
            return db.parse(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void fixSecurityDocumentBuilder(DocumentBuilderFactory dbf) throws ParserConfigurationException {
        String FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
        dbf.setFeature(FEATURE, true);
        FEATURE = "http://xml.org/sax/features/external-general-entities";
        dbf.setFeature(FEATURE, false);
        FEATURE = "http://xml.org/sax/features/external-parameter-entities";
        dbf.setFeature(FEATURE, false);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DataWsUtil.fixSecurityDocumentBuilder(dbf);
        dbf.setNamespaceAware(true);
        return dbf;
    }

    public static String formatXML(String unformattedXml) {
        try {
            Document document = DataWsUtil.parseXmlFile(unformattedXml);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            transformerFactory.setAttribute("indent-number", 3);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            transformer.transform(source, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Exception e) {
            log.error("formatXML error: ", (Throwable)e);
            return "";
        }
    }

    public static List<String> getListDataByTag(String realData, String fromKey, String toKey) {
        ArrayList<String> list = new ArrayList<String>();
        if (DataUtil.isNullOrEmpty(realData)) {
            return list;
        }
        while (realData.contains(toKey)) {
            String data = DataWsUtil.getDataByTag(realData, fromKey, toKey);
            list.add(data);
            int index = realData.indexOf(toKey) + toKey.length();
            realData = realData.substring(index);
        }
        return list;
    }

    public static Unmarshaller getInstance(Class<?> clz) {
        Unmarshaller obj = instance.get(clz);
        if (obj != null) {
            return obj;
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clz});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            instance.put(clz, unmarshaller);
            return unmarshaller;
        }
        catch (JAXBException e) {
            log.error("Init Unmarshaller error", (Throwable)e);
            return null;
        }
    }
}

