/*
 * Decompiled with CFR 0.152.
 */
package com.reactify;

import com.reactify.DataUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class SortingUtils {
    public static final String SPLIT_OPERATOR = ",";
    public static final String MINUS_OPERATOR = "-";
    public static final String PLUS_OPERATOR = "+";
    public static final String DESC = "desc";
    public static final String ASC = "asc";
    public static final String FILED_DISPLAY = "$1_$2";

    public static String parseSorting(String sortConfig, Class<?> objectClass) {
        List<String> convertSorting = SortingUtils.convertSorting(sortConfig.replaceAll("([a-z])([A-Z]+)", FILED_DISPLAY), objectClass);
        if (convertSorting == null || convertSorting.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)SPLIT_OPERATOR, convertSorting.toString().toLowerCase().replace("[", "").replace("]", ""));
    }

    public static List<String> convertSorting(String sortConfig, Class<?> objectClass) {
        if (DataUtil.isNullOrEmpty(sortConfig)) {
            return null;
        }
        List<String> filedNames = SortingUtils.getFieldsOfClass(objectClass);
        String[] sortElements = sortConfig.split(SPLIT_OPERATOR);
        LinkedList<String> orderList = new LinkedList<String>();
        for (String element : sortElements) {
            if (element == null) continue;
            if (element.startsWith(MINUS_OPERATOR)) {
                SortingUtils.handleElement(element, MINUS_OPERATOR, filedNames, orderList);
                continue;
            }
            if (!element.startsWith(PLUS_OPERATOR)) continue;
            SortingUtils.handleElement(element, PLUS_OPERATOR, filedNames, orderList);
        }
        return orderList;
    }

    private static void handleElement(String element, String operator, List<String> fields, List<String> orderList) {
        if (element.length() <= operator.length()) {
            return;
        }
        String field = element.substring(element.indexOf(operator) + operator.length());
        if (fields.contains(field)) {
            orderList.add(field + " " + SortingUtils.convertOperator(operator));
        }
    }

    private static List<String> getFieldsOfClass(Class<?> object) {
        ArrayList<String> filedNames = new ArrayList<String>();
        for (Field field : SortingUtils.getAllFields(object)) {
            filedNames.add(field.getName().replaceAll("([a-z])([A-Z]+)", FILED_DISPLAY));
        }
        return filedNames;
    }

    private static String convertOperator(String operator) {
        if (MINUS_OPERATOR.equals(operator)) {
            return DESC;
        }
        return ASC;
    }

    private static Field[] getAllFields(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            Field[] superFields = SortingUtils.getAllFields(superClass);
            Field[] allFields = new Field[fields.length + superFields.length];
            System.arraycopy(fields, 0, allFields, 0, fields.length);
            System.arraycopy(superFields, 0, allFields, fields.length, superFields.length);
            fields = allFields;
        }
        return fields;
    }
}

