/*
 * Decompiled with CFR 0.152.
 */
package com.reactify;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.reactify.DataUtil;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.springframework.util.MultiValueMap;

public class TruncateUtils {
    public static String truncate(String s, int maxByte) {
        try {
            if (DataUtil.isNullOrEmpty(s)) {
                return s;
            }
            byte[] utf8Bytes = s.getBytes(StandardCharsets.UTF_8);
            if (utf8Bytes.length <= maxByte) {
                return s;
            }
            return TruncateUtils.truncateBody(s, maxByte);
        }
        catch (Exception exception) {
            return s;
        }
    }

    public static String truncateBody(String s, int maxByte) {
        int b = 0;
        for (int i = 0; i < s.length(); ++i) {
            int more;
            char c = s.charAt(i);
            int skip = 0;
            if (c <= '\u007f') {
                more = 1;
            } else if (c <= '\u07ff') {
                more = 2;
            } else if (c <= '\ud7ff') {
                more = 3;
            } else if (c <= '\udfff') {
                more = 4;
                skip = 1;
            } else {
                more = 3;
            }
            if (b + more > maxByte) {
                return s.substring(0, i);
            }
            b += more;
            i += skip;
        }
        return s;
    }

    public static String truncateBody(Object responseBody) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(responseBody);
        }
        catch (Exception e) {
            return "Truncated and remove if has exception";
        }
    }

    private String truncateBody(MultiValueMap<String, String> formData) {
        StringBuilder messageResponse = new StringBuilder();
        Set keys = formData.keySet();
        for (String key : keys) {
            messageResponse.append(key).append(":").append(TruncateUtils.truncateBody(formData.get((Object)key)));
        }
        return messageResponse.toString();
    }
}

