/*
 * Decompiled with CFR 0.152.
 */
package com.reactify;

import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class AppUtils {
    private static final Logger log = LoggerFactory.getLogger(AppUtils.class);

    public static void runHiddenStream(Mono<?> functionMono) {
        functionMono.subscribeOn(Schedulers.boundedElastic()).timeout(Duration.ofMinutes(2L)).doOnError(e -> log.error("runHiddenStream ex: ", e)).subscribe();
    }

    public static void runHiddenStreamTimeout(Mono<?> functionMono, int timeout) {
        functionMono.subscribeOn(Schedulers.boundedElastic()).timeout(Duration.ofMinutes(timeout)).doOnError(e -> log.error("runHiddenStream ex: ", e)).subscribe();
    }

    public static void runHiddenStreamWithoutTimeout(Mono<?> functionMono) {
        functionMono.subscribeOn(Schedulers.boundedElastic()).doOnError(e -> log.error("runHiddenStream ex: ", e)).subscribe();
    }

    public static Mono<Boolean> insertData(Mono<?> functionMono) {
        return functionMono.map(rs -> true).switchIfEmpty(Mono.just((Object)true)).onErrorResume(throwable -> Mono.just((Object)false));
    }
}

