/*
 * Decompiled with CFR 0.152.
 */
package com.reactify;

import com.reactify.DataUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConvertUtils {
    private static final Logger log = LogManager.getLogger(ConvertUtils.class);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.###");

    public static String convertStringJsonRawValue(String valueRaw) {
        return !DataUtil.isNullOrEmpty(valueRaw) ? "\"".concat(valueRaw).concat("\"") : "\"\"";
    }

    public static String stripTags(String str) {
        int startPosition = ((String)str).indexOf(60);
        while (startPosition != -1) {
            int endPosition = ((String)str).indexOf(62, startPosition);
            str = ((String)str).substring(0, startPosition) + (endPosition != -1 ? ((String)str).substring(endPosition + 1) : "");
            startPosition = ((String)str).indexOf(60);
        }
        return str;
    }

    public static String convertNumber(Number number) {
        if (number == null) {
            return "0";
        }
        DecimalFormat decimalFormat = new DecimalFormat();
        DecimalFormatSymbols symbols = decimalFormat.getDecimalFormatSymbols();
        symbols.setGroupingSeparator('.');
        symbols.setDecimalSeparator(',');
        decimalFormat.setDecimalFormatSymbols(symbols);
        return decimalFormat.format(number);
    }

    public static Number convertNumber(String number) {
        if (number == null) {
            return 0;
        }
        try {
            return DECIMAL_FORMAT.parse(number);
        }
        catch (ParseException e) {
            return 0;
        }
    }

    public static boolean compareSpecial(Object obj, String target) {
        return obj != null && obj.toString().equals(target);
    }

    public static int getRegPackage(String code, List<String> packUsing, List<String> canceledList) {
        if (canceledList.contains(code)) {
            return 3;
        }
        if (packUsing.contains(code)) {
            return 1;
        }
        return 0;
    }
}

