/*
 * Decompiled with CFR 0.152.
 */
package com.reactify;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class MarshallerFactory {
    private static final Logger log = Logger.getLogger(MarshallerFactory.class.getName());
    private static final Map<Class<?>, Marshaller> instance = new ConcurrentHashMap();

    public static String convertObjectToXML(Object obj, Class<?> cls) {
        Objects.requireNonNull(obj, "Object to convert must not be null");
        Objects.requireNonNull(cls, "Class of the object must not be null");
        try {
            Marshaller marshaller = instance.computeIfAbsent(cls, key -> {
                try {
                    Marshaller m = JAXBContext.newInstance((Class[])new Class[]{key}).createMarshaller();
                    m.setProperty("jaxb.formatted.output", (Object)true);
                    return m;
                }
                catch (JAXBException ex) {
                    log.log(Level.SEVERE, "Failed to create marshaller for class: " + key.getName(), ex);
                    throw new RuntimeException("Failed to create marshaller", ex);
                }
            });
            StringWriter sw = new StringWriter();
            marshaller.marshal(obj, (Writer)sw);
            return sw.toString();
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, "Failed to convert object to XML", ex);
            return "";
        }
        catch (RuntimeException ex) {
            log.log(Level.SEVERE, "Unexpected error during XML conversion", ex);
            return "";
        }
    }
}

