/*
 * Decompiled with CFR 0.152.
 */
package com.reactify;

import com.reactify.AppUtils;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class MessageUtils {
    private static final Logger log = LoggerFactory.getLogger(AppUtils.class);
    private static final String BASE_NAME = "messages";

    public static String getMessage(String code, Locale locale) {
        return MessageUtils.getMessage(code, locale, new Object[]{null});
    }

    public static String getMessage(String code, Locale locale, Object ... args) {
        String message;
        ResourceBundle resourceBundle = ResourceBundle.getBundle(BASE_NAME, locale);
        try {
            message = resourceBundle.getString(code);
            message = MessageFormat.format(message, args);
        }
        catch (Exception ex) {
            log.debug(ex.getMessage(), (Throwable)ex);
            message = code;
        }
        return message;
    }

    public static String getMessage(String code) {
        return MessageUtils.getMessage(code, LocaleContextHolder.getLocale(), new Object[]{null});
    }

    public static String getMessage(String code, Object ... args) {
        return MessageUtils.getMessage(code, LocaleContextHolder.getLocale(), args);
    }
}

