/*
 * Decompiled with CFR 0.152.
 */
package com.reactify;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.reactify.DataUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ObjectMapperUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final DateFormat dateFormatYMdHms = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public static String convertObjectToJson(Object object) {
        if (DataUtil.isNullOrEmpty(object)) {
            return null;
        }
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException ex) {
            return null;
        }
    }

    public <T> T convertStringToObject(String objectString, Class<T> valueType) {
        if (DataUtil.isNullOrEmpty(objectString)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(objectString, valueType);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public <T> List<T> convertStringListToObjectList(List<?> stringList, Class<T> targetClass) {
        if (DataUtil.isNullOrEmpty(stringList)) {
            return null;
        }
        ArrayList<Object> objectList = new ArrayList<Object>();
        for (Object item : stringList) {
            Object object = objectMapper.convertValue(item, targetClass);
            objectList.add(object);
        }
        return objectList;
    }

    public <T> T convertToObject(byte[] byteArray, Class<T> valueType) {
        try {
            return (T)objectMapper.readValue(byteArray, valueType);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public <T> List<T> convertToObject(List<Object> input, Class<T> valueType) {
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            for (Object object : input) {
                results.add(objectMapper.convertValue(object, valueType));
            }
            return results;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public <T> T convertToObject(Object input, Class<T> valueType) {
        try {
            return (T)objectMapper.convertValue(input, valueType);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static <T> T convertObject(Object input, Class<T> valueType) {
        return (T)objectMapper.convertValue(input, valueType);
    }

    public static String convertObjectToJsonForLocalDateTime(Object object) {
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.setDateFormat(dateFormatYMdHms);
        return ObjectMapperUtil.convertObjectToJson(object);
    }

    static {
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }
}

