/*
 * Decompiled with CFR 0.152.
 */
package com.reactify;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;

public class ObjectMapperFactory {
    private static volatile ObjectMapper objectMapper;
    private static final ObjectMapper objectMapperV2;
    private static final ObjectMapper defaultGetInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectMapper getInstance() {
        if (objectMapper != null) return objectMapper;
        Class<ObjectMapperFactory> clazz = ObjectMapperFactory.class;
        synchronized (ObjectMapperFactory.class) {
            if (objectMapper != null) return objectMapper;
            objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
            objectMapper.configure(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS, true);
            SimpleModule module = new SimpleModule();
            module.addDeserializer(Boolean.TYPE, (JsonDeserializer)new NumericBooleanDeserializer());
            module.addDeserializer(Boolean.class, (JsonDeserializer)new NumericBooleanDeserializer());
            objectMapper.registerModule((Module)new JavaTimeModule());
            objectMapper.registerModule((Module)module);
            // ** MonitorExit[var0] (shouldn't be in output)
            return objectMapper;
        }
    }

    public static ObjectMapper getInstance2() {
        objectMapperV2.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapperV2.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        return objectMapperV2;
    }

    public static ObjectMapper defaultGetInstance() {
        defaultGetInstance.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        defaultGetInstance.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        defaultGetInstance.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        defaultGetInstance.findAndRegisterModules();
        return defaultGetInstance;
    }

    static {
        objectMapperV2 = new ObjectMapper();
        defaultGetInstance = new ObjectMapper();
    }

    private static class NumericBooleanDeserializer
    extends JsonDeserializer<Boolean> {
        private NumericBooleanDeserializer() {
        }

        public Boolean deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String text;
            return switch (text = p.getText().trim()) {
                case "1", "true" -> Boolean.TRUE;
                case "0", "false" -> Boolean.FALSE;
                default -> null;
            };
        }
    }
}

