/*
 * Decompiled with CFR 0.152.
 */
package com.reactify;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrUtils {
    private static final Logger log = LoggerFactory.getLogger(SolrUtils.class);
    private Map<String, String> queryParams = new HashMap<String, String>();
    public static final List<String> ALLOW_PARAMS = List.of("start", "rows", "q", "sort");
    public static final String QUERY_PARAM = "q";
    public static final String START_PARAM = "start";
    public static final String LIMIT_PARAM = "rows";
    public static final String SORT_PARAM = "sort";
    public static final String SORT_ASC = "ASC";
    public static final String SORT_DESC = "desc";

    private SolrUtils(Map<String, String> queryParams) {
        this.queryParams = queryParams;
    }

    private String getQuery() {
        return this.queryParams.keySet().stream().map(key -> key + "=" + this.encodeValue(this.queryParams.get(key))).collect(Collectors.joining("&"));
    }

    private String encodeValue(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    public static class SolrQueryBuilder {
        private final Map<String, String> queryParams = new HashMap<String, String>();

        public SolrQueryBuilder addQuery(String value) {
            this.queryParams.put(SolrUtils.QUERY_PARAM, value);
            return this;
        }

        public SolrQueryBuilder addStart(int start) {
            this.queryParams.put(SolrUtils.START_PARAM, String.valueOf(start));
            return this;
        }

        public SolrQueryBuilder addLimit(int limit) {
            this.queryParams.put(SolrUtils.LIMIT_PARAM, String.valueOf(limit));
            return this;
        }

        public SolrQueryBuilder addSort(String sortColumn, String des) {
            if (!SolrQueryBuilder.isBlank(des)) {
                if (des.equals(SolrUtils.SORT_ASC)) {
                    this.queryParams.put(SolrUtils.SORT_PARAM, sortColumn + " ASC");
                } else {
                    this.queryParams.put(SolrUtils.SORT_PARAM, sortColumn + " desc");
                }
            } else {
                this.queryParams.put(SolrUtils.SORT_PARAM, sortColumn);
            }
            return this;
        }

        public static boolean isBlank(CharSequence cs) {
            int strLen;
            int n = strLen = cs == null ? 0 : cs.length();
            if (strLen != 0) {
                for (int i = 0; i < strLen; ++i) {
                    if (Character.isWhitespace(cs.charAt(i))) continue;
                    return false;
                }
            }
            return true;
        }

        public SolrQueryBuilder addCustomParam(String key, Object value) {
            this.queryParams.put(key, String.valueOf(value));
            return this;
        }

        public String build() {
            SolrUtils solrQuery = new SolrUtils(this.queryParams);
            return solrQuery.getQuery();
        }
    }
}

