/*
 * Decompiled with CFR 0.152.
 */
package com.reactify;

import com.reactify.DataUtil;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidateUtils {
    public static final String PHONE_REGEX = "((\\+84|84|0)+(3|5|7|8|9|1|2[2|4|6|8|9]))+([0-9]{8,9})\\b";
    public static final String NUMBER_REGEX = "\\d+";
    public static final String EMAIL_REGEX = "^(?![-_.@])[\\w.-]+(?<![-_.@])@[a-zA-Z0-9.-]+\\.[a-zA-Z0-9]{2,}$";
    public static final String OTP_REGEX = "^\\d{6}$";
    public static final String PASSWORD_REGEX = "^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[a-zA-Z]).{8,}$";
    public static final String UTF8_REGEX = "^[ -~]{8,}$";
    public static final String CAMELCASE = "([a-z])([A-Z]+)";
    public static final String DATE_FORMAT = "^([0-2][0-9]|(3)[0-1])(\\/)(((0)[0-9])|((1)[0-2]))(\\/)\\d{4}$";
    public static final String PRODUCT_ID = "^[a-zA-Z0-9\\s-]*$";
    public static final String LINK = "^(http:\\/\\/|https:\\/\\/)(www\\.)?[a-zA-Z0-9@:%._\\+~#=]{2,256}(\\.[a-z]{2,6})?(:\\d+)?\\b([-a-zA-Z0-9@:%_\\+.~#?&//=]*)$";
    public static final String TAX_CODE_REGEX = "^\\d\\d{9}$|^\\d\\d{12}$";
    public static final String PHONE_NUMBER_FORMAT = "^8496\\d{7}$|^8497\\d{7}$|^8498\\d{7}$|^8416\\d{8}$|0?96\\d{7}$|0?97\\d{7}$|^0?98\\d{7}$|^0?16\\d{8}$";

    public static boolean validateRegex(String input, String regexPattern) {
        return !DataUtil.isNullOrEmpty(input) && input.matches(regexPattern);
    }

    public static boolean validatePhone(String phone) {
        if (DataUtil.isNullOrEmpty(phone)) {
            return true;
        }
        if (!phone.matches(NUMBER_REGEX)) {
            return false;
        }
        return phone.length() >= 9 && phone.length() <= 11;
    }

    public static boolean validateUUID(String uuidValue) {
        if (DataUtil.isNullOrEmpty(uuidValue)) {
            return false;
        }
        try {
            return DataUtil.safeEqual(UUID.fromString(uuidValue).toString(), uuidValue);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean validateLink(String link) {
        if (DataUtil.isNullOrEmpty(link)) {
            return false;
        }
        Pattern pattern = Pattern.compile(LINK);
        Matcher matcher = pattern.matcher(link);
        return matcher.matches();
    }
}

