/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.request.handler;

import io.github.ibuildthecloud.gdapi.context.ApiContext;
import io.github.ibuildthecloud.gdapi.model.Resource;
import io.github.ibuildthecloud.gdapi.model.impl.CollectionImpl;
import io.github.ibuildthecloud.gdapi.request.ApiRequest;
import io.github.ibuildthecloud.gdapi.request.handler.AbstractResponseGenerator;
import io.github.ibuildthecloud.gdapi.version.Versions;
import io.github.ibuildthecloud.model.impl.VersionImpl;
import io.github.ibuildthecloud.url.UrlBuilder;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;

public class VersionsHandler
extends AbstractResponseGenerator {
    Versions versions;

    @Override
    protected void generate(ApiRequest request) throws IOException {
        if (request.getRequestVersion() != null) {
            return;
        }
        UrlBuilder urlBuilder = ApiContext.getUrlBuilder();
        ArrayList<Resource> apiVersions = new ArrayList<Resource>();
        for (String version : this.versions.getVersions()) {
            apiVersions.add(new VersionImpl(version));
        }
        CollectionImpl collection = new CollectionImpl();
        collection.getLinks().put("latest", urlBuilder.version(this.versions.getLatest()));
        collection.getLinks().put("self", urlBuilder.current());
        collection.setData(apiVersions);
        collection.setResourceType(((Resource)apiVersions.get(0)).getType());
        request.setResponseObject(collection);
    }

    @Inject
    public void setVersions(Versions versions) {
        this.versions = versions;
    }

    public Versions getVersions() {
        return this.versions;
    }
}

