/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.request.parser;

import io.github.ibuildthecloud.gdapi.exception.ClientVisibleException;
import io.github.ibuildthecloud.gdapi.request.ApiRequest;
import io.github.ibuildthecloud.gdapi.request.parser.ApiRequestParser;
import io.github.ibuildthecloud.gdapi.util.RequestUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang3.StringUtils;

public class DefaultApiRequestParser
implements ApiRequestParser {
    public static final String DEFAULT_OVERRIDE_URL_HEADER = "X-API-request-url";
    public static final String DEFAULT_OVERRIDE_CLIENT_IP_HEADER = "X-API-client-ip";
    public static final String FORWARDED_HEADER = "X-Forwarded-For";
    public static final String HTML = "html";
    public static final String JSON = "json";
    ServletFileUpload servletFileUpload;
    int maxUploadSize = 102400;
    boolean allowClientOverrideHeaders = false;
    String overrideUrlHeader = "X-API-request-url";
    String overrideClientIpHeader = "X-API-client-ip";
    Set<String> allowedFormats;
    String trimPrefix;

    @Override
    public boolean parse(ApiRequest apiRequest) throws IOException {
        HttpServletRequest request = apiRequest.getServletContext().getRequest();
        apiRequest.setLocale(this.getLocale(apiRequest, request));
        apiRequest.setMethod(this.parseMethod(apiRequest, request));
        apiRequest.setAction(this.parseAction(apiRequest, request));
        apiRequest.setRequestParams(this.parseParams(apiRequest, request));
        apiRequest.setRequestUrl(this.parseRequestUrl(apiRequest, request));
        apiRequest.setClientIp(this.parseClientIp(apiRequest, request));
        apiRequest.setResponseUrlBase(this.parseResponseUrlBase(apiRequest, request));
        apiRequest.setRequestVersion(this.parseRequestVersion(apiRequest, request));
        apiRequest.setResponseFormat(this.parseResponseType(apiRequest, request));
        apiRequest.setQueryString(this.parseQueryString(apiRequest, request));
        this.parsePath(apiRequest, request);
        return true;
    }

    protected Locale getLocale(ApiRequest apiRequest, HttpServletRequest request) {
        return request.getLocale();
    }

    protected String parseQueryString(ApiRequest apiRequest, HttpServletRequest request) {
        return request.getQueryString();
    }

    protected String parseMethod(ApiRequest apiRequest, HttpServletRequest request) {
        String method = request.getParameter("_method");
        if (method == null) {
            method = request.getMethod();
        }
        return method;
    }

    protected String parseAction(ApiRequest apiRequest, HttpServletRequest request) {
        if ("POST".equals(apiRequest.getMethod())) {
            return request.getParameter("action");
        }
        return null;
    }

    protected Map<String, Object> parseParams(ApiRequest apiRequest, HttpServletRequest request) throws IOException {
        try {
            Map multiPart = this.parseMultipart(request);
            return multiPart == null ? request.getParameterMap() : multiPart;
        }
        catch (IOException e) {
            if (e.getCause() instanceof FileUploadBase.SizeLimitExceededException) {
                throw new ClientVisibleException(413);
            }
            throw e;
        }
    }

    protected Map<String, Object> parseMultipart(HttpServletRequest request) throws IOException {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return null;
        }
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        try {
            List items = this.servletFileUpload.parseRequest(request);
            for (FileItem item : items) {
                if (!item.isFormField()) continue;
                ArrayList<String> values = (ArrayList<String>)params.get(item.getFieldName());
                if (values == null) {
                    values = new ArrayList<String>();
                    params.put(item.getFieldName(), values);
                }
                values.add(item.getString());
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry entry : params.entrySet()) {
                List values = (List)entry.getValue();
                result.put((String)entry.getKey(), values.toArray(new String[values.size()]));
            }
            return result;
        }
        catch (FileUploadException e) {
            throw new IOException(e);
        }
    }

    protected String getOverrideHeader(HttpServletRequest request, String header, String defaultValue) {
        return this.getOverrideHeader(request, header, defaultValue, true);
    }

    protected String getOverrideHeader(HttpServletRequest request, String header, String defaultValue, boolean checkSetting) {
        if (checkSetting && !this.isAllowClientOverrideHeaders()) {
            return defaultValue;
        }
        String value = request.getHeader(header);
        return value == null ? defaultValue : value;
    }

    protected String parseClientIp(ApiRequest apiRequest, HttpServletRequest request) {
        String clientIp = request.getRemoteAddr();
        clientIp = this.getOverrideHeader(request, this.overrideClientIpHeader, clientIp);
        clientIp = this.getOverrideHeader(request, FORWARDED_HEADER, clientIp, false);
        return clientIp;
    }

    protected String parseRequestUrl(ApiRequest apiRequest, HttpServletRequest request) {
        String requestUrl = null;
        try {
            requestUrl = URLDecoder.decode(request.getRequestURL().toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        requestUrl = this.getOverrideHeader(request, this.overrideUrlHeader, requestUrl);
        return requestUrl;
    }

    protected String parseResponseUrlBase(ApiRequest apiRequest, HttpServletRequest request) {
        String servletPath = request.getServletPath();
        String requestUrl = apiRequest.getRequestUrl();
        int index = requestUrl.lastIndexOf(servletPath);
        if (index == -1) {
            try {
                URL url = new URL(requestUrl);
                StringBuilder buffer = new StringBuilder(url.getProtocol()).append("://").append(url.getHost());
                if (url.getPort() != -1) {
                    buffer.append(":").append(url.getPort());
                }
                return buffer.toString();
            }
            catch (MalformedURLException e) {
                throw new ClientVisibleException(404);
            }
        }
        return requestUrl.substring(0, index);
    }

    protected String parseRequestVersion(ApiRequest apiRequest, HttpServletRequest request) {
        String servletPath = request.getServletPath();
        if (!(servletPath = this.trimPrefix(servletPath.replaceAll("//+", "/"))).startsWith("/") || servletPath.length() < 2) {
            return null;
        }
        return servletPath.split("/")[1];
    }

    protected String trimPrefix(String path) {
        if (this.trimPrefix != null && path.startsWith(this.trimPrefix)) {
            return path.substring(this.trimPrefix.length());
        }
        return path;
    }

    protected String parseResponseType(ApiRequest apiRequest, HttpServletRequest request) {
        String format = request.getParameter("_format");
        if (format != null) {
            format = format.toLowerCase().trim();
        }
        if (format != null && this.allowedFormats.contains(format)) {
            return format;
        }
        if (RequestUtils.isBrowser(request, true)) {
            return HTML;
        }
        return JSON;
    }

    protected void parsePath(ApiRequest apiRequest, HttpServletRequest request) {
        String versionPrefix;
        if (apiRequest.getRequestVersion() == null) {
            return;
        }
        String servletPath = request.getServletPath();
        if (!(servletPath = this.trimPrefix(servletPath.replaceAll("//+", "/"))).startsWith(versionPrefix = "/" + apiRequest.getRequestVersion())) {
            return;
        }
        String[] parts = servletPath.substring(versionPrefix.length()).split("/");
        if (parts.length > 4) {
            return;
        }
        String typeName = this.indexValue(parts, 1);
        String id = this.indexValue(parts, 2);
        String link = this.indexValue(parts, 3);
        if (StringUtils.isBlank((CharSequence)typeName)) {
            return;
        }
        String singleType = apiRequest.getSchemaFactory().getSingularName(typeName);
        apiRequest.setType(singleType == null ? typeName : singleType);
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        apiRequest.setId(id);
        if (StringUtils.isBlank((CharSequence)link)) {
            return;
        }
        apiRequest.setLink(link);
    }

    protected String indexValue(String[] array, int index) {
        if (array.length <= index) {
            return null;
        }
        String value = array[index];
        return value == null ? value : value.trim();
    }

    @PostConstruct
    public void init() {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(this.maxUploadSize * 2);
        this.servletFileUpload = new ServletFileUpload((FileItemFactory)factory);
        this.servletFileUpload.setFileSizeMax((long)this.maxUploadSize);
        this.servletFileUpload.setSizeMax((long)this.maxUploadSize);
        if (this.allowedFormats == null) {
            this.allowedFormats = new HashSet<String>();
            this.allowedFormats.add(HTML);
            this.allowedFormats.add(JSON);
        }
    }

    public Set<String> getAllowedFormats() {
        return this.allowedFormats;
    }

    public void setAllowedFormats(Set<String> allowedFormats) {
        this.allowedFormats = allowedFormats;
    }

    public boolean isAllowClientOverrideHeaders() {
        return this.allowClientOverrideHeaders;
    }

    public void setAllowClientOverrideHeaders(boolean allowClientOverrideHeaders) {
        this.allowClientOverrideHeaders = allowClientOverrideHeaders;
    }

    public String getTrimPrefix() {
        return this.trimPrefix;
    }

    public void setTrimPrefix(String trimPrefix) {
        this.trimPrefix = trimPrefix;
    }
}

