/*
 * Decompiled with CFR 0.152.
 */
package io.github.imfangs.dify.client;

import io.github.imfangs.dify.client.DifyChatClient;
import io.github.imfangs.dify.client.DifyChatflowClient;
import io.github.imfangs.dify.client.DifyClient;
import io.github.imfangs.dify.client.DifyCompletionClient;
import io.github.imfangs.dify.client.DifyDatasetsClient;
import io.github.imfangs.dify.client.DifyWorkflowClient;
import io.github.imfangs.dify.client.impl.DefaultDifyClient;
import io.github.imfangs.dify.client.impl.DefaultDifyDatasetsClient;
import io.github.imfangs.dify.client.model.DifyConfig;
import io.github.imfangs.dify.client.util.HttpClientUtils;
import okhttp3.OkHttpClient;

public class DifyClientFactory {
    public static DifyClient createClient(String baseUrl, String apiKey) {
        return DifyClientFactory.createClient(baseUrl, apiKey, HttpClientUtils.createDefaultClient());
    }

    public static DifyClient createClient(String baseUrl, String apiKey, OkHttpClient httpClient) {
        return new DefaultDifyClient(baseUrl, apiKey, httpClient);
    }

    public static DifyClient createClient(DifyConfig config) {
        OkHttpClient httpClient = HttpClientUtils.createClient(config.getConnectTimeout(), config.getReadTimeout(), config.getWriteTimeout());
        return new DefaultDifyClient(config.getBaseUrl(), config.getApiKey(), httpClient);
    }

    public static DifyChatClient createChatClient(String baseUrl, String apiKey) {
        return DifyClientFactory.createClient(baseUrl, apiKey);
    }

    public static DifyChatflowClient createChatWorkflowClient(String baseUrl, String apiKey) {
        return DifyClientFactory.createClient(baseUrl, apiKey);
    }

    public static DifyCompletionClient createCompletionClient(String baseUrl, String apiKey) {
        return DifyClientFactory.createClient(baseUrl, apiKey);
    }

    public static DifyWorkflowClient createWorkflowClient(String baseUrl, String apiKey) {
        return DifyClientFactory.createClient(baseUrl, apiKey);
    }

    public static DifyDatasetsClient createDatasetsClient(String baseUrl, String apiKey) {
        return DifyClientFactory.createDatasetsClient(baseUrl, apiKey, HttpClientUtils.createDefaultClient());
    }

    public static DifyDatasetsClient createDatasetsClient(String baseUrl, String apiKey, OkHttpClient httpClient) {
        return new DefaultDifyDatasetsClient(baseUrl, apiKey, httpClient);
    }

    public static DifyDatasetsClient createDatasetsClient(DifyConfig config) {
        OkHttpClient httpClient = HttpClientUtils.createClient(config.getConnectTimeout(), config.getReadTimeout(), config.getWriteTimeout());
        return new DefaultDifyDatasetsClient(config.getBaseUrl(), config.getApiKey(), httpClient);
    }
}

