/*
 * Decompiled with CFR 0.152.
 */
package io.github.imfangs.dify.client.impl;

import io.github.imfangs.dify.client.DifyClient;
import io.github.imfangs.dify.client.callback.BaseStreamCallback;
import io.github.imfangs.dify.client.callback.ChatStreamCallback;
import io.github.imfangs.dify.client.callback.ChatflowStreamCallback;
import io.github.imfangs.dify.client.callback.CompletionStreamCallback;
import io.github.imfangs.dify.client.callback.WorkflowStreamCallback;
import io.github.imfangs.dify.client.enums.ResponseMode;
import io.github.imfangs.dify.client.event.BaseEvent;
import io.github.imfangs.dify.client.exception.DifyApiException;
import io.github.imfangs.dify.client.impl.AbstractDifyClient;
import io.github.imfangs.dify.client.impl.DifyBaseClientImpl;
import io.github.imfangs.dify.client.impl.StreamEventDispatcher;
import io.github.imfangs.dify.client.model.chat.AppMetaResponse;
import io.github.imfangs.dify.client.model.chat.AudioToTextResponse;
import io.github.imfangs.dify.client.model.chat.ChatMessage;
import io.github.imfangs.dify.client.model.chat.ChatMessageResponse;
import io.github.imfangs.dify.client.model.chat.Conversation;
import io.github.imfangs.dify.client.model.chat.ConversationListResponse;
import io.github.imfangs.dify.client.model.chat.MessageListResponse;
import io.github.imfangs.dify.client.model.chat.SuggestedQuestionsResponse;
import io.github.imfangs.dify.client.model.common.SimpleResponse;
import io.github.imfangs.dify.client.model.completion.CompletionRequest;
import io.github.imfangs.dify.client.model.completion.CompletionResponse;
import io.github.imfangs.dify.client.model.workflow.WorkflowLogsResponse;
import io.github.imfangs.dify.client.model.workflow.WorkflowRunRequest;
import io.github.imfangs.dify.client.model.workflow.WorkflowRunResponse;
import io.github.imfangs.dify.client.model.workflow.WorkflowRunStatusResponse;
import io.github.imfangs.dify.client.model.workflow.WorkflowStopResponse;
import io.github.imfangs.dify.client.util.JsonUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.function.Consumer;
import lombok.Generated;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDifyClient
extends DifyBaseClientImpl
implements DifyClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDifyClient.class);
    private static final String DONE_MARKER = "[DONE]";
    private static final String DATA_PREFIX = "data:";
    private static final String CHAT_MESSAGES_PATH = "/chat-messages";
    private static final String MESSAGES_PATH = "/messages";
    private static final String CONVERSATIONS_PATH = "/conversations";
    private static final String AUDIO_TO_TEXT_PATH = "/audio-to-text";
    private static final String TEXT_TO_AUDIO_PATH = "/text-to-audio";
    private static final String META_PATH = "/meta";
    private static final String STOP_PATH = "/stop";
    private static final String FEEDBACKS_PATH = "/feedbacks";
    private static final String SUGGESTED_QUESTIONS_PATH = "/suggested-questions";
    private static final String NAME_PATH = "/name";
    private static final String COMPLETION_MESSAGES_PATH = "/completion-messages";
    private static final String WORKFLOWS_PATH = "/workflows";
    private static final String WORKFLOWS_RUN_PATH = "/workflows/run";
    private static final String WORKFLOWS_TASKS_PATH = "/workflows/tasks";
    private static final String WORKFLOWS_LOGS_PATH = "/workflows/logs";

    public DefaultDifyClient(String baseUrl, String apiKey) {
        super(baseUrl, apiKey);
    }

    public DefaultDifyClient(String baseUrl, String apiKey, OkHttpClient httpClient) {
        super(baseUrl, apiKey, httpClient);
    }

    @Override
    public ChatMessageResponse sendChatMessage(ChatMessage message) throws IOException, DifyApiException {
        log.debug("\u53d1\u9001\u5bf9\u8bdd\u6d88\u606f: {}", (Object)message);
        return this.executePost(CHAT_MESSAGES_PATH, message, ChatMessageResponse.class);
    }

    @Override
    public void sendChatMessageStream(ChatMessage message, ChatStreamCallback callback) throws IOException, DifyApiException {
        log.debug("\u53d1\u9001\u6d41\u5f0f\u5bf9\u8bdd\u6d88\u606f: user={}, inputs={}", (Object)message.getUser(), message.getInputs() != null ? message.getInputs().keySet() : null);
        message.setResponseMode(ResponseMode.STREAMING);
        this.executeStreamRequest(CHAT_MESSAGES_PATH, message, line -> this.processStreamLine(line, callback, (data, eventType) -> StreamEventDispatcher.dispatchChatEvent(callback, data, eventType)), callback::onException);
    }

    @Override
    public void sendChatMessageStream(ChatMessage message, ChatflowStreamCallback callback) throws IOException, DifyApiException {
        log.debug("\u53d1\u9001\u6d41\u5f0f\u5bf9\u8bdd\u6d88\u606f: user={}, inputs={}", (Object)message.getUser(), message.getInputs() != null ? message.getInputs().keySet() : null);
        message.setResponseMode(ResponseMode.STREAMING);
        this.executeStreamRequest(CHAT_MESSAGES_PATH, message, line -> this.processStreamLine(line, callback, (data, eventType) -> StreamEventDispatcher.dispatchChatFlowEvent(callback, data, eventType)), callback::onException);
    }

    @Override
    public SimpleResponse stopChatMessage(String taskId, String user) throws IOException, DifyApiException {
        log.debug("\u505c\u6b62\u5bf9\u8bdd\u6d88\u606f: taskId={}, user={}", (Object)taskId, (Object)user);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("user", user);
        return this.executePost("/chat-messages/" + taskId + STOP_PATH, body, SimpleResponse.class);
    }

    @Override
    public SimpleResponse feedbackMessage(String messageId, String rating, String user, String content) throws IOException, DifyApiException {
        log.debug("\u6d88\u606f\u53cd\u9988: messageId={}, rating={}, user={}", new Object[]{messageId, rating, user});
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("rating", rating);
        body.put("user", user);
        if (content != null) {
            body.put("content", content);
        }
        return this.executePost("/messages/" + messageId + FEEDBACKS_PATH, body, SimpleResponse.class);
    }

    @Override
    public SuggestedQuestionsResponse getSuggestedQuestions(String messageId, String user) throws IOException, DifyApiException {
        log.debug("\u83b7\u53d6\u5efa\u8bae\u95ee\u9898: messageId={}, user={}", (Object)messageId, (Object)user);
        return this.executeGet("/messages/" + messageId + "/suggested-questions?user=" + user, SuggestedQuestionsResponse.class);
    }

    @Override
    public MessageListResponse getMessages(String conversationId, String user, String firstId, Integer limit) throws IOException, DifyApiException {
        log.debug("\u83b7\u53d6\u6d88\u606f\u5217\u8868: conversationId={}, user={}, firstId={}, limit={}", new Object[]{conversationId, user, firstId, limit});
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("conversation_id", conversationId);
        params.put("user", user);
        params.put("first_id", firstId);
        params.put("limit", limit);
        String url = this.buildUrlWithParams(MESSAGES_PATH, params);
        Request request = this.createGetRequest(url.substring(this.baseUrl.length()));
        return this.executeRequest(request, MessageListResponse.class);
    }

    @Override
    public ConversationListResponse getConversations(String user, String lastId, Integer limit, String sortBy) throws IOException, DifyApiException {
        log.debug("\u83b7\u53d6\u4f1a\u8bdd\u5217\u8868: user={}, lastId={}, limit={}, sortBy={}", new Object[]{user, lastId, limit, sortBy});
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user", user);
        params.put("last_id", lastId);
        params.put("limit", limit);
        params.put("sort_by", sortBy);
        String url = this.buildUrlWithParams(CONVERSATIONS_PATH, params);
        Request request = this.createGetRequest(url.substring(this.baseUrl.length()));
        return this.executeRequest(request, ConversationListResponse.class);
    }

    @Override
    public SimpleResponse deleteConversation(String conversationId, String user) throws IOException, DifyApiException {
        log.debug("\u5220\u9664\u4f1a\u8bdd: conversationId={}, user={}", (Object)conversationId, (Object)user);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("user", user);
        return this.executeDelete("/conversations/" + conversationId, body, SimpleResponse.class);
    }

    @Override
    public Conversation renameConversation(String conversationId, String name, Boolean autoGenerate, String user) throws IOException, DifyApiException {
        log.debug("\u91cd\u547d\u540d\u4f1a\u8bdd: conversationId={}, name={}, autoGenerate={}, user={}", new Object[]{conversationId, name, autoGenerate, user});
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("name", name);
        body.put("auto_generate", autoGenerate);
        body.put("user", user);
        return this.executePost("/conversations/" + conversationId + NAME_PATH, body, Conversation.class);
    }

    @Override
    public AudioToTextResponse audioToText(File file, String user) throws IOException, DifyApiException {
        log.debug("\u8bed\u97f3\u8f6c\u6587\u5b57: fileName={}, user={}", (Object)file.getName(), (Object)user);
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.create((MediaType)AUDIO, (File)file)).addFormDataPart("user", user).build();
        Request request = new Request.Builder().url(this.baseUrl + AUDIO_TO_TEXT_PATH).post((RequestBody)requestBody).header("Authorization", "Bearer " + this.apiKey).build();
        return this.executeRequest(request, AudioToTextResponse.class);
    }

    @Override
    public AudioToTextResponse audioToText(final InputStream inputStream, String fileName, String user) throws IOException, DifyApiException {
        log.debug("\u8bed\u97f3\u8f6c\u6587\u5b57: fileName={}, user={}", (Object)fileName, (Object)user);
        RequestBody fileBody = new RequestBody(){

            public MediaType contentType() {
                return AbstractDifyClient.AUDIO;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                try (Source source = Okio.source((InputStream)inputStream);){
                    sink.writeAll(source);
                }
            }
        };
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", fileName, fileBody).addFormDataPart("user", user).build();
        Request request = new Request.Builder().url(this.baseUrl + AUDIO_TO_TEXT_PATH).post((RequestBody)requestBody).header("Authorization", "Bearer " + this.apiKey).build();
        return this.executeRequest(request, AudioToTextResponse.class);
    }

    @Override
    public byte[] textToAudio(String messageId, String text, String user) throws IOException, DifyApiException {
        log.debug("\u6587\u5b57\u8f6c\u8bed\u97f3: messageId={}, text={}, user={}", new Object[]{messageId, text, user});
        HashMap<String, String> body = new HashMap<String, String>();
        if (messageId != null) {
            body.put("message_id", messageId);
        }
        if (text != null) {
            body.put("text", text);
        }
        body.put("user", user);
        RequestBody requestBody = this.createJsonRequestBody(body);
        Request request = this.createPostRequest(TEXT_TO_AUDIO_PATH, requestBody);
        return this.executeRequestForBytes(request);
    }

    @Override
    public AppMetaResponse getAppMeta() throws IOException, DifyApiException {
        return this.executeGet(META_PATH, AppMetaResponse.class);
    }

    @Override
    public CompletionResponse sendCompletionMessage(CompletionRequest request) throws IOException, DifyApiException {
        log.debug("\u53d1\u9001\u6587\u672c\u751f\u6210\u8bf7\u6c42: {}", (Object)request);
        return this.executePost(COMPLETION_MESSAGES_PATH, request, CompletionResponse.class);
    }

    @Override
    public void sendCompletionMessageStream(CompletionRequest request, CompletionStreamCallback callback) throws IOException, DifyApiException {
        log.debug("\u53d1\u9001\u6d41\u5f0f\u6587\u672c\u751f\u6210\u8bf7\u6c42: {}", (Object)request);
        request.setResponseMode(ResponseMode.STREAMING);
        this.executeStreamRequest(COMPLETION_MESSAGES_PATH, request, line -> this.processStreamLine(line, callback, (data, eventType) -> StreamEventDispatcher.dispatchCompletionEvent(callback, data)), callback::onException);
    }

    @Override
    public SimpleResponse stopCompletion(String taskId, String user) throws IOException, DifyApiException {
        log.debug("\u505c\u6b62\u6587\u672c\u751f\u6210: taskId={}, user={}", (Object)taskId, (Object)user);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("user", user);
        return this.executePost("/completion-messages/" + taskId + STOP_PATH, body, SimpleResponse.class);
    }

    @Override
    public WorkflowRunResponse runWorkflow(WorkflowRunRequest request) throws IOException, DifyApiException {
        log.debug("\u6267\u884c\u5de5\u4f5c\u6d41: {}", (Object)request);
        return this.executePost(WORKFLOWS_RUN_PATH, request, WorkflowRunResponse.class);
    }

    @Override
    public void runWorkflowStream(WorkflowRunRequest request, WorkflowStreamCallback callback) throws IOException, DifyApiException {
        log.debug("\u6267\u884c\u6d41\u5f0f\u5de5\u4f5c\u6d41: {}", (Object)request);
        request.setResponseMode(ResponseMode.STREAMING);
        this.executeStreamRequest(WORKFLOWS_RUN_PATH, request, line -> this.processStreamLine(line, callback, (data, eventType) -> StreamEventDispatcher.dispatchWorkflowEvent(callback, data)), callback::onException);
    }

    @Override
    public WorkflowStopResponse stopWorkflow(String taskId, String user) throws IOException, DifyApiException {
        log.debug("\u505c\u6b62\u5de5\u4f5c\u6d41: taskId={}, user={}", (Object)taskId, (Object)user);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("user", user);
        return this.executePost("/workflows/tasks/" + taskId + STOP_PATH, body, WorkflowStopResponse.class);
    }

    @Override
    public WorkflowRunStatusResponse getWorkflowRun(String workflowId) throws IOException, DifyApiException {
        log.debug("\u83b7\u53d6\u5de5\u4f5c\u6d41\u6267\u884c\u72b6\u6001: workflowId={}", (Object)workflowId);
        return this.executeGet("/workflows/run/" + workflowId, WorkflowRunStatusResponse.class);
    }

    @Override
    public WorkflowLogsResponse getWorkflowLogs(String keyword, String status, Integer page, Integer limit) throws IOException, DifyApiException {
        log.debug("\u83b7\u53d6\u5de5\u4f5c\u6d41\u65e5\u5fd7: keyword={}, status={}, page={}, limit={}", new Object[]{keyword, status, page, limit});
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("keyword", keyword);
        params.put("status", status);
        params.put("page", page);
        params.put("limit", limit);
        String url = this.buildUrlWithParams(WORKFLOWS_LOGS_PATH, params);
        Request request = this.createGetRequest(url.substring(this.baseUrl.length()));
        return this.executeRequest(request, WorkflowLogsResponse.class);
    }

    private void executeStreamRequest(String path, Object body, final LineProcessor lineProcessor, final Consumer<Exception> errorHandler) {
        RequestBody requestBody = this.createJsonRequestBody(body);
        Request httpRequest = new Request.Builder().url(this.baseUrl + path).post(requestBody).header("Authorization", "Bearer " + this.apiKey).header("Content-Type", "application/json").header("Accept", "text/event-stream").build();
        Call call = this.httpClient.newCall(httpRequest);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.error("\u6d41\u5f0f\u8bf7\u6c42\u5931\u8d25: {}", (Object)e.getMessage());
                errorHandler.accept(e);
            }

            public void onResponse(Call call, Response response) {
                if (!response.isSuccessful()) {
                    try {
                        String errorBody = response.body() != null ? response.body().string() : "";
                        DifyApiException exception = DefaultDifyClient.this.createApiException(response.code(), errorBody);
                        log.error("\u6d41\u5f0f\u8bf7\u6c42\u5931\u8d25: {}", (Object)exception.getMessage());
                        errorHandler.accept(exception);
                    }
                    catch (IOException e) {
                        log.error("\u8bfb\u53d6\u9519\u8bef\u54cd\u5e94\u5931\u8d25", (Throwable)e);
                        errorHandler.accept(e);
                    }
                    return;
                }
                try (ResponseBody responseBody = response.body();){
                    if (responseBody == null) {
                        IOException exception = new IOException("\u7a7a\u54cd\u5e94\u4f53");
                        log.error("\u6d41\u5f0f\u8bf7\u6c42\u5931\u8d25: {}", (Object)exception.getMessage());
                        errorHandler.accept(exception);
                        return;
                    }
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(responseBody.byteStream(), StandardCharsets.UTF_8));){
                        String line;
                        while ((line = reader.readLine()) != null && (line.isEmpty() || lineProcessor.process(line))) {
                        }
                    }
                }
                catch (Exception e) {
                    log.error("\u5904\u7406\u6d41\u5f0f\u54cd\u5e94\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
                    errorHandler.accept(e);
                }
            }
        });
    }

    private boolean processStreamLine(String line, BaseStreamCallback callback, EventProcessor eventProcessor) {
        if (line.startsWith(DATA_PREFIX)) {
            String data = line.substring(DATA_PREFIX.length()).trim();
            if (DONE_MARKER.equals(data)) {
                callback.onComplete();
                return false;
            }
            try {
                BaseEvent baseEvent = JsonUtils.fromJson(data, BaseEvent.class);
                if (baseEvent == null) {
                    log.warn("\u89e3\u6790\u4e8b\u4ef6\u6570\u636e\u4e3anull: {}", (Object)data);
                    return true;
                }
                eventProcessor.process(data, baseEvent.getEvent());
            }
            catch (Exception e) {
                log.error("\u89e3\u6790\u4e8b\u4ef6\u6570\u636e\u5931\u8d25: {}", (Object)data, (Object)e);
                callback.onException(e);
            }
        }
        return true;
    }

    @FunctionalInterface
    private static interface LineProcessor {
        public boolean process(String var1);
    }

    @FunctionalInterface
    private static interface EventProcessor {
        public void process(String var1, String var2);
    }
}

