/*
 * Decompiled with CFR 0.152.
 */
package io.github.imfangs.dify.client.impl;

import io.github.imfangs.dify.client.DifyBaseClient;
import io.github.imfangs.dify.client.exception.DifyApiException;
import io.github.imfangs.dify.client.impl.AbstractDifyClient;
import io.github.imfangs.dify.client.model.chat.AppInfoResponse;
import io.github.imfangs.dify.client.model.chat.AppParametersResponse;
import io.github.imfangs.dify.client.model.file.FileUploadRequest;
import io.github.imfangs.dify.client.model.file.FileUploadResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DifyBaseClientImpl
extends AbstractDifyClient
implements DifyBaseClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DifyBaseClientImpl.class);
    private static final String FILES_UPLOAD_PATH = "/files/upload";
    private static final String INFO_PATH = "/info";
    private static final String PARAMETERS_PATH = "/parameters";

    public DifyBaseClientImpl(String baseUrl, String apiKey) {
        super(baseUrl, apiKey);
    }

    public DifyBaseClientImpl(String baseUrl, String apiKey, OkHttpClient httpClient) {
        super(baseUrl, apiKey, httpClient);
    }

    @Override
    public FileUploadResponse uploadFile(File file, String user) throws IOException, DifyApiException {
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.create((MediaType)OCTET_STREAM, (File)file)).addFormDataPart("user", user).build();
        return this.uploadFile((RequestBody)requestBody);
    }

    @Override
    public FileUploadResponse uploadFile(FileUploadRequest request, File file) throws IOException, DifyApiException {
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.create((MediaType)OCTET_STREAM, (File)file)).addFormDataPart("user", request.getUser()).build();
        return this.uploadFile((RequestBody)requestBody);
    }

    @Override
    public FileUploadResponse uploadFile(FileUploadRequest request, final InputStream inputStream, String fileName) throws IOException, DifyApiException {
        RequestBody fileBody = new RequestBody(){

            public MediaType contentType() {
                return AbstractDifyClient.OCTET_STREAM;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                try (Source source = Okio.source((InputStream)inputStream);){
                    sink.writeAll(source);
                }
            }
        };
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", fileName, fileBody).addFormDataPart("user", request.getUser()).build();
        return this.uploadFile((RequestBody)requestBody);
    }

    private FileUploadResponse uploadFile(RequestBody requestBody) throws IOException, DifyApiException {
        Request httpRequest = new Request.Builder().url(this.baseUrl + FILES_UPLOAD_PATH).post(requestBody).header("Authorization", "Bearer " + this.apiKey).build();
        return this.executeRequest(httpRequest, FileUploadResponse.class);
    }

    @Override
    public AppInfoResponse getAppInfo() throws IOException, DifyApiException {
        return this.executeGet(INFO_PATH, AppInfoResponse.class);
    }

    @Override
    public AppParametersResponse getAppParameters() throws IOException, DifyApiException {
        return this.executeGet(PARAMETERS_PATH, AppParametersResponse.class);
    }

    @Override
    public void close() {
    }
}

