/*
 * Decompiled with CFR 0.152.
 */
package io.github.imfangs.dify.client.impl;

import io.github.imfangs.dify.client.callback.ChatStreamCallback;
import io.github.imfangs.dify.client.callback.ChatflowStreamCallback;
import io.github.imfangs.dify.client.callback.CompletionStreamCallback;
import io.github.imfangs.dify.client.callback.WorkflowStreamCallback;
import io.github.imfangs.dify.client.enums.EventType;
import io.github.imfangs.dify.client.event.AgentMessageEvent;
import io.github.imfangs.dify.client.event.AgentThoughtEvent;
import io.github.imfangs.dify.client.event.BaseEvent;
import io.github.imfangs.dify.client.event.ErrorEvent;
import io.github.imfangs.dify.client.event.MessageEndEvent;
import io.github.imfangs.dify.client.event.MessageEvent;
import io.github.imfangs.dify.client.event.MessageFileEvent;
import io.github.imfangs.dify.client.event.MessageReplaceEvent;
import io.github.imfangs.dify.client.event.NodeFinishedEvent;
import io.github.imfangs.dify.client.event.NodeStartedEvent;
import io.github.imfangs.dify.client.event.PingEvent;
import io.github.imfangs.dify.client.event.TtsMessageEndEvent;
import io.github.imfangs.dify.client.event.TtsMessageEvent;
import io.github.imfangs.dify.client.event.WorkflowFinishedEvent;
import io.github.imfangs.dify.client.event.WorkflowStartedEvent;
import io.github.imfangs.dify.client.util.JsonUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamEventDispatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamEventDispatcher.class);

    public static void dispatchChatFlowEvent(ChatflowStreamCallback callback, String data, String eventType) {
        try {
            EventType type = EventType.fromValue(eventType);
            if (type == null) {
                log.warn("\u672a\u77e5\u4e8b\u4ef6\u7c7b\u578b: {}", (Object)eventType);
                return;
            }
            switch (type) {
                case MESSAGE: {
                    MessageEvent messageEvent = JsonUtils.fromJson(data, MessageEvent.class);
                    callback.onMessage(messageEvent);
                    break;
                }
                case MESSAGE_END: {
                    MessageEndEvent messageEndEvent = JsonUtils.fromJson(data, MessageEndEvent.class);
                    callback.onMessageEnd(messageEndEvent);
                    break;
                }
                case MESSAGE_FILE: {
                    MessageFileEvent messageFileEvent = JsonUtils.fromJson(data, MessageFileEvent.class);
                    callback.onMessageFile(messageFileEvent);
                    break;
                }
                case TTS_MESSAGE: {
                    TtsMessageEvent ttsMessageEvent = JsonUtils.fromJson(data, TtsMessageEvent.class);
                    callback.onTTSMessage(ttsMessageEvent);
                    break;
                }
                case TTS_MESSAGE_END: {
                    TtsMessageEndEvent ttsMessageEndEvent = JsonUtils.fromJson(data, TtsMessageEndEvent.class);
                    callback.onTTSMessageEnd(ttsMessageEndEvent);
                    break;
                }
                case MESSAGE_REPLACE: {
                    MessageReplaceEvent messageReplaceEvent = JsonUtils.fromJson(data, MessageReplaceEvent.class);
                    callback.onMessageReplace(messageReplaceEvent);
                    break;
                }
                case AGENT_MESSAGE: {
                    AgentMessageEvent agentMessageEvent = JsonUtils.fromJson(data, AgentMessageEvent.class);
                    callback.onAgentMessage(agentMessageEvent);
                    break;
                }
                case AGENT_THOUGHT: {
                    AgentThoughtEvent agentThoughtEvent = JsonUtils.fromJson(data, AgentThoughtEvent.class);
                    callback.onAgentThought(agentThoughtEvent);
                    break;
                }
                case WORKFLOW_STARTED: {
                    WorkflowStartedEvent workflowStartedEvent = JsonUtils.fromJson(data, WorkflowStartedEvent.class);
                    callback.onWorkflowStarted(workflowStartedEvent);
                    break;
                }
                case NODE_STARTED: {
                    NodeStartedEvent nodeStartedEvent = JsonUtils.fromJson(data, NodeStartedEvent.class);
                    callback.onNodeStarted(nodeStartedEvent);
                    break;
                }
                case NODE_FINISHED: {
                    NodeFinishedEvent nodeFinishedEvent = JsonUtils.fromJson(data, NodeFinishedEvent.class);
                    callback.onNodeFinished(nodeFinishedEvent);
                    break;
                }
                case WORKFLOW_FINISHED: {
                    WorkflowFinishedEvent workflowFinishedEvent = JsonUtils.fromJson(data, WorkflowFinishedEvent.class);
                    callback.onWorkflowFinished(workflowFinishedEvent);
                    break;
                }
                case ERROR: {
                    ErrorEvent errorEvent = JsonUtils.fromJson(data, ErrorEvent.class);
                    callback.onError(errorEvent);
                    break;
                }
                case PING: {
                    PingEvent pingEvent = JsonUtils.fromJson(data, PingEvent.class);
                    callback.onPing(pingEvent);
                    break;
                }
                default: {
                    log.warn("\u672a\u5904\u7406\u7684\u4e8b\u4ef6\u7c7b\u578b: {}", (Object)eventType);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u4e8b\u4ef6\u56de\u8c03\u65f6\u53d1\u751f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            try {
                callback.onException(e);
            }
            catch (Exception ex) {
                log.error("\u8c03\u7528onError\u56de\u8c03\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            }
        }
    }

    public static void dispatchChatEvent(ChatStreamCallback callback, String data, String eventType) {
        try {
            EventType type = EventType.fromValue(eventType);
            if (type == null) {
                log.warn("\u672a\u77e5\u4e8b\u4ef6\u7c7b\u578b: {}", (Object)eventType);
                return;
            }
            switch (type) {
                case MESSAGE: {
                    MessageEvent messageEvent = JsonUtils.fromJson(data, MessageEvent.class);
                    callback.onMessage(messageEvent);
                    break;
                }
                case MESSAGE_END: {
                    MessageEndEvent messageEndEvent = JsonUtils.fromJson(data, MessageEndEvent.class);
                    callback.onMessageEnd(messageEndEvent);
                    break;
                }
                case MESSAGE_FILE: {
                    MessageFileEvent messageFileEvent = JsonUtils.fromJson(data, MessageFileEvent.class);
                    callback.onMessageFile(messageFileEvent);
                    break;
                }
                case TTS_MESSAGE: {
                    TtsMessageEvent ttsMessageEvent = JsonUtils.fromJson(data, TtsMessageEvent.class);
                    callback.onTTSMessage(ttsMessageEvent);
                    break;
                }
                case TTS_MESSAGE_END: {
                    TtsMessageEndEvent ttsMessageEndEvent = JsonUtils.fromJson(data, TtsMessageEndEvent.class);
                    callback.onTTSMessageEnd(ttsMessageEndEvent);
                    break;
                }
                case MESSAGE_REPLACE: {
                    MessageReplaceEvent messageReplaceEvent = JsonUtils.fromJson(data, MessageReplaceEvent.class);
                    callback.onMessageReplace(messageReplaceEvent);
                    break;
                }
                case AGENT_MESSAGE: {
                    AgentMessageEvent agentMessageEvent = JsonUtils.fromJson(data, AgentMessageEvent.class);
                    callback.onAgentMessage(agentMessageEvent);
                    break;
                }
                case AGENT_THOUGHT: {
                    AgentThoughtEvent agentThoughtEvent = JsonUtils.fromJson(data, AgentThoughtEvent.class);
                    callback.onAgentThought(agentThoughtEvent);
                    break;
                }
                case ERROR: {
                    ErrorEvent errorEvent = JsonUtils.fromJson(data, ErrorEvent.class);
                    callback.onError(errorEvent);
                    break;
                }
                case PING: {
                    PingEvent pingEvent = JsonUtils.fromJson(data, PingEvent.class);
                    callback.onPing(pingEvent);
                    break;
                }
                default: {
                    log.warn("\u672a\u5904\u7406\u7684\u4e8b\u4ef6\u7c7b\u578b: {}", (Object)eventType);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u4e8b\u4ef6\u56de\u8c03\u65f6\u53d1\u751f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            try {
                callback.onException(e);
            }
            catch (Exception ex) {
                log.error("\u8c03\u7528onError\u56de\u8c03\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            }
        }
    }

    public static void dispatchCompletionEvent(CompletionStreamCallback callback, String data) {
        try {
            EventType type;
            BaseEvent baseEvent = JsonUtils.fromJson(data, BaseEvent.class);
            if (baseEvent == null) {
                log.warn("\u89e3\u6790\u4e8b\u4ef6\u6570\u636e\u4e3anull: {}", (Object)data);
                return;
            }
            String eventTypeStr = baseEvent.getEvent();
            EventType eventType = type = eventTypeStr != null ? EventType.fromValue(eventTypeStr) : null;
            if (type == null) {
                MessageEvent messageEvent = JsonUtils.fromJson(data, MessageEvent.class);
                callback.onMessage(messageEvent);
                return;
            }
            switch (type) {
                case MESSAGE: {
                    MessageEvent messageEvent = JsonUtils.fromJson(data, MessageEvent.class);
                    callback.onMessage(messageEvent);
                    break;
                }
                case MESSAGE_END: {
                    MessageEndEvent messageEndEvent = JsonUtils.fromJson(data, MessageEndEvent.class);
                    callback.onMessageEnd(messageEndEvent);
                    break;
                }
                case TTS_MESSAGE: {
                    TtsMessageEvent ttsMessageEvent = JsonUtils.fromJson(data, TtsMessageEvent.class);
                    callback.onTtsMessage(ttsMessageEvent);
                    break;
                }
                case TTS_MESSAGE_END: {
                    TtsMessageEndEvent ttsMessageEndEvent = JsonUtils.fromJson(data, TtsMessageEndEvent.class);
                    callback.onTtsMessageEnd(ttsMessageEndEvent);
                    break;
                }
                case MESSAGE_REPLACE: {
                    MessageReplaceEvent messageReplaceEvent = JsonUtils.fromJson(data, MessageReplaceEvent.class);
                    callback.onMessageReplace(messageReplaceEvent);
                    break;
                }
                case ERROR: {
                    ErrorEvent errorEvent = JsonUtils.fromJson(data, ErrorEvent.class);
                    callback.onError(errorEvent);
                    break;
                }
                case PING: {
                    PingEvent pingEvent = JsonUtils.fromJson(data, PingEvent.class);
                    callback.onPing(pingEvent);
                    break;
                }
                default: {
                    log.warn("\u672a\u5904\u7406\u7684\u4e8b\u4ef6\u7c7b\u578b: {}", (Object)eventTypeStr);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u4e8b\u4ef6\u56de\u8c03\u65f6\u53d1\u751f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            try {
                callback.onException(e);
            }
            catch (Exception ex) {
                log.error("\u8c03\u7528onError\u56de\u8c03\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            }
        }
    }

    public static void dispatchWorkflowEvent(WorkflowStreamCallback callback, String data) {
        try {
            BaseEvent baseEvent = JsonUtils.fromJson(data, BaseEvent.class);
            if (baseEvent == null) {
                log.warn("\u89e3\u6790\u4e8b\u4ef6\u6570\u636e\u4e3anull: {}", (Object)data);
                return;
            }
            String eventTypeStr = baseEvent.getEvent();
            EventType type = EventType.fromValue(eventTypeStr);
            if (type == null) {
                log.warn("\u672a\u77e5\u4e8b\u4ef6\u7c7b\u578b: {}", (Object)eventTypeStr);
                return;
            }
            switch (type) {
                case WORKFLOW_STARTED: {
                    WorkflowStartedEvent workflowStartedEvent = JsonUtils.fromJson(data, WorkflowStartedEvent.class);
                    callback.onWorkflowStarted(workflowStartedEvent);
                    break;
                }
                case NODE_STARTED: {
                    NodeStartedEvent nodeStartedEvent = JsonUtils.fromJson(data, NodeStartedEvent.class);
                    callback.onNodeStarted(nodeStartedEvent);
                    break;
                }
                case NODE_FINISHED: {
                    NodeFinishedEvent nodeFinishedEvent = JsonUtils.fromJson(data, NodeFinishedEvent.class);
                    callback.onNodeFinished(nodeFinishedEvent);
                    break;
                }
                case WORKFLOW_FINISHED: {
                    WorkflowFinishedEvent workflowFinishedEvent = JsonUtils.fromJson(data, WorkflowFinishedEvent.class);
                    callback.onWorkflowFinished(workflowFinishedEvent);
                    break;
                }
                case TTS_MESSAGE: {
                    TtsMessageEvent ttsMessageEvent = JsonUtils.fromJson(data, TtsMessageEvent.class);
                    callback.onTtsMessage(ttsMessageEvent);
                    break;
                }
                case TTS_MESSAGE_END: {
                    TtsMessageEndEvent ttsMessageEndEvent = JsonUtils.fromJson(data, TtsMessageEndEvent.class);
                    callback.onTtsMessageEnd(ttsMessageEndEvent);
                    break;
                }
                case PING: {
                    PingEvent pingEvent = JsonUtils.fromJson(data, PingEvent.class);
                    callback.onPing(pingEvent);
                    break;
                }
                case ERROR: {
                    ErrorEvent errorEvent = JsonUtils.fromJson(data, ErrorEvent.class);
                    callback.onError(errorEvent);
                    break;
                }
                default: {
                    log.warn("\u672a\u5904\u7406\u7684\u4e8b\u4ef6\u7c7b\u578b: {}", (Object)eventTypeStr);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u4e8b\u4ef6\u56de\u8c03\u65f6\u53d1\u751f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            try {
                callback.onException(e);
            }
            catch (Exception ex) {
                log.error("\u8c03\u7528onError\u56de\u8c03\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            }
        }
    }
}

