/*
 * Decompiled with CFR 0.152.
 */
package io.github.imfangs.dify.client;

import io.github.imfangs.dify.client.DifyChatClient;
import io.github.imfangs.dify.client.DifyChatflowClient;
import io.github.imfangs.dify.client.DifyClient;
import io.github.imfangs.dify.client.DifyCompletionClient;
import io.github.imfangs.dify.client.DifyDatasetsClient;
import io.github.imfangs.dify.client.DifyWorkflowClient;
import io.github.imfangs.dify.client.impl.DefaultDifyClient;
import io.github.imfangs.dify.client.impl.DefaultDifyDatasetsClient;
import io.github.imfangs.dify.client.model.DifyConfig;
import io.github.imfangs.dify.client.util.HttpClientUtils;
import okhttp3.OkHttpClient;

public class DifyClientFactory {
    private static OkHttpClient createHttpClient(DifyConfig config) {
        return HttpClientUtils.createClient(config.getConnectTimeout(), config.getReadTimeout(), config.getWriteTimeout());
    }

    public static DifyClient createClient(String baseUrl, String apiKey) {
        return DifyClientFactory.createClient(baseUrl, apiKey, HttpClientUtils.createDefaultClient());
    }

    public static DifyClient createClient(String baseUrl, String apiKey, OkHttpClient httpClient) {
        return new DefaultDifyClient(baseUrl, apiKey, httpClient);
    }

    public static DifyClient createClient(DifyConfig config) {
        return new DefaultDifyClient(config.getBaseUrl(), config.getApiKey(), DifyClientFactory.createHttpClient(config));
    }

    public static DifyChatClient createChatClient(String baseUrl, String apiKey) {
        return DifyClientFactory.createClient(baseUrl, apiKey);
    }

    public static DifyChatClient createChatClient(String baseUrl, String apiKey, OkHttpClient httpClient) {
        return DifyClientFactory.createClient(baseUrl, apiKey, httpClient);
    }

    public static DifyChatClient createChatClient(DifyConfig config) {
        return DifyClientFactory.createClient(config);
    }

    public static DifyChatflowClient createChatWorkflowClient(String baseUrl, String apiKey) {
        return DifyClientFactory.createClient(baseUrl, apiKey);
    }

    public static DifyChatflowClient createChatWorkflowClient(String baseUrl, String apiKey, OkHttpClient httpClient) {
        return DifyClientFactory.createClient(baseUrl, apiKey, httpClient);
    }

    public static DifyChatflowClient createChatWorkflowClient(DifyConfig config) {
        return DifyClientFactory.createClient(config);
    }

    public static DifyCompletionClient createCompletionClient(String baseUrl, String apiKey) {
        return DifyClientFactory.createClient(baseUrl, apiKey);
    }

    public static DifyCompletionClient createCompletionClient(String baseUrl, String apiKey, OkHttpClient httpClient) {
        return DifyClientFactory.createClient(baseUrl, apiKey, httpClient);
    }

    public static DifyCompletionClient createCompletionClient(DifyConfig config) {
        return DifyClientFactory.createClient(config);
    }

    public static DifyWorkflowClient createWorkflowClient(String baseUrl, String apiKey) {
        return DifyClientFactory.createClient(baseUrl, apiKey);
    }

    public static DifyWorkflowClient createWorkflowClient(String baseUrl, String apiKey, OkHttpClient httpClient) {
        return DifyClientFactory.createClient(baseUrl, apiKey, httpClient);
    }

    public static DifyWorkflowClient createWorkflowClient(DifyConfig config) {
        return DifyClientFactory.createClient(config);
    }

    public static DifyDatasetsClient createDatasetsClient(String baseUrl, String apiKey) {
        return DifyClientFactory.createDatasetsClient(baseUrl, apiKey, HttpClientUtils.createDefaultClient());
    }

    public static DifyDatasetsClient createDatasetsClient(String baseUrl, String apiKey, OkHttpClient httpClient) {
        return new DefaultDifyDatasetsClient(baseUrl, apiKey, httpClient);
    }

    public static DifyDatasetsClient createDatasetsClient(DifyConfig config) {
        return new DefaultDifyDatasetsClient(config.getBaseUrl(), config.getApiKey(), DifyClientFactory.createHttpClient(config));
    }
}

