/*
 * Decompiled with CFR 0.152.
 */
package io.github.imfangs.dify.client.impl;

import io.github.imfangs.dify.client.DifyBaseClient;
import io.github.imfangs.dify.client.exception.DifyApiException;
import io.github.imfangs.dify.client.impl.AbstractDifyClient;
import io.github.imfangs.dify.client.model.chat.AppInfoResponse;
import io.github.imfangs.dify.client.model.chat.AppParametersResponse;
import io.github.imfangs.dify.client.model.chat.AppWebAppSettingResponse;
import io.github.imfangs.dify.client.model.file.FilePreviewResponse;
import io.github.imfangs.dify.client.model.file.FileUploadRequest;
import io.github.imfangs.dify.client.model.file.FileUploadResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import lombok.Generated;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DifyBaseClientImpl
extends AbstractDifyClient
implements DifyBaseClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DifyBaseClientImpl.class);
    private static final String FILES_UPLOAD_PATH = "/files/upload";
    private static final String FILES_PREVIEW_PATH = "/files/{file_id}/preview";
    private static final String INFO_PATH = "/info";
    private static final String PARAMETERS_PATH = "/parameters";
    private static final String SITE_PATH = "/site";

    public DifyBaseClientImpl(String baseUrl, String apiKey) {
        super(baseUrl, apiKey);
    }

    public DifyBaseClientImpl(String baseUrl, String apiKey, OkHttpClient httpClient) {
        super(baseUrl, apiKey, httpClient);
    }

    @Override
    public FileUploadResponse uploadFile(File file, String user) throws IOException, DifyApiException {
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.create((File)file, (MediaType)OCTET_STREAM)).addFormDataPart("user", user).build();
        return this.uploadFile((RequestBody)requestBody);
    }

    @Override
    public FileUploadResponse uploadFile(FileUploadRequest request, File file) throws IOException, DifyApiException {
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.create((File)file, (MediaType)request.getMediaType())).addFormDataPart("user", request.getUser()).build();
        return this.uploadFile((RequestBody)requestBody);
    }

    @Override
    public FileUploadResponse uploadFile(final FileUploadRequest request, final InputStream inputStream, String fileName) throws IOException, DifyApiException {
        RequestBody fileBody = new RequestBody(this){
            final /* synthetic */ DifyBaseClientImpl this$0;
            {
                this.this$0 = this$0;
            }

            public MediaType contentType() {
                return request.getMediaType();
            }

            public void writeTo(BufferedSink sink) throws IOException {
                try (Source source = Okio.source((InputStream)inputStream);){
                    sink.writeAll(source);
                }
            }
        };
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", fileName, fileBody).addFormDataPart("user", request.getUser()).build();
        return this.uploadFile((RequestBody)requestBody);
    }

    private FileUploadResponse uploadFile(RequestBody requestBody) throws IOException, DifyApiException {
        Request httpRequest = new Request.Builder().url(this.baseUrl + FILES_UPLOAD_PATH).post(requestBody).header("Authorization", "Bearer " + this.apiKey).build();
        return this.executeRequest(httpRequest, FileUploadResponse.class);
    }

    @Override
    public AppInfoResponse getAppInfo() throws IOException, DifyApiException {
        return this.executeGet(INFO_PATH, AppInfoResponse.class);
    }

    @Override
    public AppParametersResponse getAppParameters() throws IOException, DifyApiException {
        return this.executeGet(PARAMETERS_PATH, AppParametersResponse.class);
    }

    @Override
    public AppWebAppSettingResponse getAppWebAppSettings() throws IOException, DifyApiException {
        return this.executeGet(SITE_PATH, AppWebAppSettingResponse.class);
    }

    @Override
    public FilePreviewResponse previewFile(String fileId) throws IOException, DifyApiException {
        return this.previewFile(fileId, false);
    }

    @Override
    public FilePreviewResponse previewFile(String fileId, boolean asAttachment) throws IOException, DifyApiException {
        if (fileId == null || fileId.trim().isEmpty()) {
            throw new IllegalArgumentException("\u6587\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String url = this.baseUrl + FILES_PREVIEW_PATH.replace("{file_id}", fileId.trim());
        if (asAttachment) {
            url = url + "?as_attachment=true";
        }
        Request request = new Request.Builder().url(url).get().header("Authorization", "Bearer " + this.apiKey).build();
        return this.executeFilePreviewRequest(request, asAttachment);
    }

    private FilePreviewResponse executeFilePreviewRequest(Request request, boolean asAttachment) throws IOException, DifyApiException {
        String acceptRanges;
        String fileName;
        String contentDisposition;
        Response response = this.httpClient.newCall(request).execute();
        if (!response.isSuccessful()) {
            String errorBody = response.body() != null ? response.body().string() : "";
            throw this.createApiException(response.code(), errorBody);
        }
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            throw new DifyApiException(500, "empty_response", "\u54cd\u5e94\u4f53\u4e3a\u7a7a");
        }
        Headers headers = response.headers();
        FilePreviewResponse.FilePreviewResponseBuilder builder = FilePreviewResponse.builder().inputStream(responseBody.byteStream()).isAttachment(asAttachment).contentType(headers.get("Content-Type")).cacheControl(headers.get("Cache-Control"));
        String contentLengthHeader = headers.get("Content-Length");
        if (contentLengthHeader != null) {
            try {
                builder.contentLength(Long.parseLong(contentLengthHeader));
            }
            catch (NumberFormatException e) {
                log.warn("\u65e0\u6cd5\u89e3\u6790 Content-Length: {}", (Object)contentLengthHeader);
            }
        }
        if ((contentDisposition = headers.get("Content-Disposition")) != null && contentDisposition.contains("filename") && (fileName = this.extractFileName(contentDisposition)) != null) {
            builder.fileName(fileName);
        }
        if ("bytes".equals(acceptRanges = headers.get("Accept-Ranges"))) {
            builder.acceptRanges(true);
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (String name : headers.names()) {
            headerMap.put(name, headers.get(name));
        }
        builder.headers(headerMap);
        return builder.build();
    }

    private String extractFileName(String contentDisposition) {
        try {
            if (contentDisposition.contains("filename*=UTF-8''")) {
                String encoded = contentDisposition.substring(contentDisposition.indexOf("filename*=UTF-8''") + 17);
                return URLDecoder.decode(encoded, "UTF-8");
            }
            if (contentDisposition.contains("filename=")) {
                String filename = contentDisposition.substring(contentDisposition.indexOf("filename=") + 9);
                if (filename.startsWith("\"") && filename.endsWith("\"")) {
                    return filename.substring(1, filename.length() - 1);
                }
                return filename;
            }
        }
        catch (Exception e) {
            log.warn("\u63d0\u53d6\u6587\u4ef6\u540d\u5931\u8d25: {}", (Object)contentDisposition, (Object)e);
        }
        return null;
    }

    @Override
    public void close() {
    }
}

