/*
 * Decompiled with CFR 0.152.
 */
package io.github.interacto.interaction;

import io.github.interacto.fsm.FSM;
import io.github.interacto.fsm.InitState;
import io.github.interacto.fsm.OutputState;
import io.github.interacto.interaction.InteractionData;
import io.github.interacto.interaction.ThreadService;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class InteractionImpl<D extends InteractionData, E, F extends FSM<E>> {
    static Logger defaultLogger = Logger.getLogger(InteractionImpl.class.getName());
    protected final F fsm;
    protected boolean activated;
    protected Logger logger;
    protected long throttleTimeout;
    protected final AtomicLong throttleCounter;
    protected E currentThrottledEvent;
    protected Future<?> currThrottleTimeoutFuture;
    protected ExecutorService executor;
    protected final Disposable disposable;
    private boolean consumeEvents;

    public static void setLogger(Logger logger) {
        if (logger != null) {
            defaultLogger = logger;
        }
    }

    protected InteractionImpl(F fsm) {
        if (fsm == null) {
            throw new IllegalArgumentException("null fsm");
        }
        this.executor = null;
        this.currThrottleTimeoutFuture = null;
        this.throttleTimeout = 0L;
        this.fsm = fsm;
        this.disposable = ((FSM)fsm).currentState().subscribe(current -> this.updateEventsRegistered((OutputState)current.getValue(), (OutputState)current.getKey()));
        this.activated = true;
        this.throttleCounter = new AtomicLong();
        this.currentThrottledEvent = null;
        this.consumeEvents = false;
    }

    public abstract D getData();

    public void setThrottleTimeout(long timeout) {
        this.throttleTimeout = timeout;
    }

    protected abstract void updateEventsRegistered(OutputState<E> var1, OutputState<E> var2);

    public boolean isRunning() {
        return this.activated && !(((FSM)this.fsm).getCurrentState() instanceof InitState);
    }

    public void fullReinit() {
        ((FSM)this.fsm).fullReinit();
    }

    private void directEventProcess(E event) {
        ((FSM)this.fsm).process(event);
        if (this.consumeEvents) {
            this.consumeEvent(event);
        }
    }

    protected abstract void consumeEvent(E var1);

    public void setConsumeEvents(boolean consumeEvents) {
        this.consumeEvents = consumeEvents;
    }

    protected abstract boolean isEventsOfSameType(E var1, E var2);

    private void createThrottleTimeout() {
        if (this.executor == null) {
            this.executor = Executors.newWorkStealingPool();
        }
        if (this.currThrottleTimeoutFuture != null && !this.currThrottleTimeoutFuture.isDone()) {
            this.currThrottleTimeoutFuture.cancel(true);
        }
        this.currThrottleTimeoutFuture = this.executor.submit(() -> {
            try {
                ThreadService.getInstance().sleep(this.throttleTimeout);
                Object evt = null;
                if (this.throttleCounter.getAndSet(0L) > 0L) {
                    evt = this.currentThrottledEvent;
                }
                this.currentThrottledEvent = null;
                if (evt != null) {
                    Object evtToProcess = evt;
                    this.runInUIThread(() -> this.directEventProcess(evtToProcess));
                }
            }
            catch (InterruptedException ex) {
                ThreadService.getInstance().currentThread().interrupt();
            }
        });
    }

    protected abstract void runInUIThread(Runnable var1);

    private boolean checkThrottlingEvent(E event) {
        if (this.currentThrottledEvent == null || !this.isEventsOfSameType(this.currentThrottledEvent, event)) {
            if (this.throttleCounter.getAndSet(0L) > 0L) {
                this.directEventProcess(event);
            }
            this.currentThrottledEvent = event;
            this.createThrottleTimeout();
            return true;
        }
        this.throttleCounter.incrementAndGet();
        this.currentThrottledEvent = event;
        return false;
    }

    public void processEvent(E event) {
        if (this.isActivated() && (this.throttleTimeout <= 0L || this.checkThrottlingEvent(event))) {
            this.directEventProcess(event);
        }
    }

    public void log(boolean log) {
        if (log) {
            if (this.logger == null) {
                this.logger = defaultLogger;
            }
        } else {
            this.logger = null;
        }
        ((FSM)this.fsm).log(log);
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        if (this.logger != null) {
            this.logger.log(Level.INFO, "Interaction activation: " + activated);
        }
        this.activated = activated;
        if (!activated) {
            ((FSM)this.fsm).fullReinit();
        }
    }

    public F getFsm() {
        return this.fsm;
    }

    protected void reinit() {
        ((FSM)this.fsm).reinit();
        this.reinitData();
    }

    protected abstract void reinitData();

    public void uninstall() {
        this.disposable.dispose();
        this.setActivated(false);
        this.logger = null;
        if (this.executor != null) {
            this.executor.shutdownNow();
            try {
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                ThreadService.getInstance().currentThread().interrupt();
            }
        }
    }
}

