/*
 * Decompiled with CFR 0.152.
 */
package glm.mat._3;

import glm.mat._3.Mat3;
import glm.mat._3.funcMatrix;
import glm.vec._3.Vec3;

abstract class matrixTransform
extends funcMatrix {
    matrixTransform() {
    }

    public Mat3 rotation(float ang, Vec3 v) {
        return this.rotation(ang, v.x, v.y, v.z);
    }

    public Mat3 rotation(float ang, float x, float y, float z) {
        float cos = (float)Math.cos(ang);
        float sin = (float)Math.sin(ang);
        float C = 1.0f - cos;
        float xy = x * y;
        float xz = x * z;
        float yz = y * z;
        this.m00 = cos + x * x * C;
        this.m10 = xy * C - z * sin;
        this.m20 = xz * C + y * sin;
        this.m01 = xy * C + z * sin;
        this.m11 = cos + y * y * C;
        this.m21 = yz * C - x * sin;
        this.m02 = xz * C - y * sin;
        this.m12 = yz * C + x * sin;
        this.m22 = cos + z * z * C;
        return (Mat3)this;
    }

    public Mat3 rotate(float angle, Vec3 v) {
        return this.rotate(angle, v.x, v.y, v.z, (Mat3)this);
    }

    public Mat3 rotate(float angle, float x, float y, float z) {
        return this.rotate(angle, x, y, z, (Mat3)this);
    }

    public Mat3 rotate(float ang, float x, float y, float z, Mat3 res) {
        float sin = (float)Math.sin(ang);
        float cos = (float)Math.cos(ang);
        float invCos = 1.0f - cos;
        float xx = x * x;
        float xy = x * y;
        float xz = x * z;
        float yy = y * y;
        float yz = y * z;
        float zz = z * z;
        float rm00 = xx * invCos + cos;
        float rm01 = xy * invCos + z * sin;
        float rm02 = xz * invCos - y * sin;
        float rm10 = xy * invCos - z * sin;
        float rm11 = yy * invCos + cos;
        float rm12 = yz * invCos + x * sin;
        float rm20 = xz * invCos + y * sin;
        float rm21 = yz * invCos - x * sin;
        float rm22 = zz * invCos + cos;
        float nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        float nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        float nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        float nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        float nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        float nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        res.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        res.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        res.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        res.m00 = nm00;
        res.m01 = nm01;
        res.m02 = nm02;
        res.m10 = nm10;
        res.m11 = nm11;
        res.m12 = nm12;
        return res;
    }

    public Mat3 rotateX(double ang) {
        return this.rotateX((float)ang, (Mat3)this);
    }

    public Mat3 rotateX(float ang) {
        return this.rotateX(ang, (Mat3)this);
    }

    public Mat3 rotateX(float ang, Mat3 res) {
        float sin;
        float cos;
        if (ang == (float)Math.PI || ang == (float)(-Math.PI)) {
            cos = -1.0f;
            sin = 0.0f;
        } else if (ang == 1.5707964f || ang == -4.712389f) {
            cos = 0.0f;
            sin = 1.0f;
        } else if (ang == -1.5707964f || ang == 4.712389f) {
            cos = 0.0f;
            sin = -1.0f;
        } else {
            cos = (float)Math.cos(ang);
            sin = (float)Math.sin(ang);
        }
        float rm11 = cos;
        float rm21 = -sin;
        float rm12 = sin;
        float rm22 = cos;
        float nm10 = this.m10 * rm11 + this.m20 * rm12;
        float nm11 = this.m11 * rm11 + this.m21 * rm12;
        float nm12 = this.m12 * rm11 + this.m22 * rm12;
        res.m20 = this.m10 * rm21 + this.m20 * rm22;
        res.m21 = this.m11 * rm21 + this.m21 * rm22;
        res.m22 = this.m12 * rm21 + this.m22 * rm22;
        res.m10 = nm10;
        res.m11 = nm11;
        res.m12 = nm12;
        res.m00 = this.m00;
        res.m01 = this.m01;
        res.m02 = this.m02;
        return res;
    }

    public Mat3 rotateY(double ang) {
        return this.rotateY((float)ang, (Mat3)this);
    }

    public Mat3 rotateY(float ang) {
        return this.rotateY(ang, (Mat3)this);
    }

    public Mat3 rotateY(float ang, Mat3 dest) {
        float sin;
        float cos;
        if (ang == (float)Math.PI || ang == (float)(-Math.PI)) {
            cos = -1.0f;
            sin = 0.0f;
        } else if (ang == 1.5707964f || ang == -4.712389f) {
            cos = 0.0f;
            sin = 1.0f;
        } else if (ang == -1.5707964f || ang == 4.712389f) {
            cos = 0.0f;
            sin = -1.0f;
        } else {
            cos = (float)Math.cos(ang);
            sin = (float)Math.sin(ang);
        }
        float rm00 = cos;
        float rm20 = sin;
        float rm02 = -sin;
        float rm22 = cos;
        float nm00 = this.m00 * rm00 + this.m20 * rm02;
        float nm01 = this.m01 * rm00 + this.m21 * rm02;
        float nm02 = this.m02 * rm00 + this.m22 * rm02;
        dest.m20 = this.m00 * rm20 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m22 * rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = this.m10;
        dest.m11 = this.m11;
        dest.m12 = this.m12;
        return dest;
    }

    public Mat3 rotateZ(double ang) {
        return this.rotateZ((float)ang, (Mat3)this);
    }

    public Mat3 rotateZ(float ang) {
        return this.rotateZ(ang, (Mat3)this);
    }

    public Mat3 rotateZ(float ang, Mat3 dest) {
        float sin;
        float cos;
        if (ang == (float)Math.PI || ang == (float)(-Math.PI)) {
            cos = -1.0f;
            sin = 0.0f;
        } else if (ang == 1.5707964f || ang == -4.712389f) {
            cos = 0.0f;
            sin = 1.0f;
        } else if (ang == -1.5707964f || ang == 4.712389f) {
            cos = 0.0f;
            sin = -1.0f;
        } else {
            cos = (float)Math.cos(ang);
            sin = (float)Math.sin(ang);
        }
        float rm00 = cos;
        float rm10 = -sin;
        float rm01 = sin;
        float rm11 = cos;
        float nm00 = this.m00 * rm00 + this.m10 * rm01;
        float nm01 = this.m01 * rm00 + this.m11 * rm01;
        float nm02 = this.m02 * rm00 + this.m12 * rm01;
        dest.m10 = this.m00 * rm10 + this.m10 * rm11;
        dest.m11 = this.m01 * rm10 + this.m11 * rm11;
        dest.m12 = this.m02 * rm10 + this.m12 * rm11;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m20 = this.m20;
        dest.m21 = this.m21;
        dest.m22 = this.m22;
        return dest;
    }

    public Mat3 rotationX(float ang) {
        float sin;
        float cos;
        if (ang == (float)Math.PI || ang == (float)(-Math.PI)) {
            cos = -1.0f;
            sin = 0.0f;
        } else if (ang == 1.5707964f || ang == -4.712389f) {
            cos = 0.0f;
            sin = 1.0f;
        } else if (ang == -1.5707964f || ang == 4.712389f) {
            cos = 0.0f;
            sin = -1.0f;
        } else {
            cos = (float)Math.cos(ang);
            sin = (float)Math.sin(ang);
        }
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = cos;
        this.m12 = sin;
        this.m20 = 0.0f;
        this.m21 = -sin;
        this.m22 = cos;
        return (Mat3)this;
    }

    public Mat3 rotationY(float ang) {
        float sin;
        float cos;
        if (ang == (float)Math.PI || ang == (float)(-Math.PI)) {
            cos = -1.0f;
            sin = 0.0f;
        } else if (ang == 1.5707964f || ang == -4.712389f) {
            cos = 0.0f;
            sin = 1.0f;
        } else if (ang == -1.5707964f || ang == 4.712389f) {
            cos = 0.0f;
            sin = -1.0f;
        } else {
            cos = (float)Math.cos(ang);
            sin = (float)Math.sin(ang);
        }
        this.m00 = cos;
        this.m01 = 0.0f;
        this.m02 = -sin;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m20 = sin;
        this.m21 = 0.0f;
        this.m22 = cos;
        return (Mat3)this;
    }

    public Mat3 rotationZ(float ang) {
        float sin;
        float cos;
        if (ang == (float)Math.PI || ang == (float)(-Math.PI)) {
            cos = -1.0f;
            sin = 0.0f;
        } else if (ang == 1.5707964f || ang == -4.712389f) {
            cos = 0.0f;
            sin = 1.0f;
        } else if (ang == -1.5707964f || ang == 4.712389f) {
            cos = 0.0f;
            sin = -1.0f;
        } else {
            cos = (float)Math.cos(ang);
            sin = (float)Math.sin(ang);
        }
        this.m00 = cos;
        this.m01 = sin;
        this.m02 = 0.0f;
        this.m10 = -sin;
        this.m11 = cos;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        return (Mat3)this;
    }
}

