/*
 * Decompiled with CFR 0.152.
 */
package glm.mat._4.d;

import glm.Glm;
import glm.mat._4.Mat4;
import glm.vec._3.d.Vec3d;
import glm.vec._4.d.Vec4d;
import java.nio.ByteBuffer;

public class Mat4d {
    public double m00;
    public double m10;
    public double m20;
    public double m30;
    public double m01;
    public double m11;
    public double m21;
    public double m31;
    public double m02;
    public double m12;
    public double m22;
    public double m32;
    public double m03;
    public double m13;
    public double m23;
    public double m33;
    public static final int SIZE = 128;

    public Mat4d() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public Mat4d(double s) {
        this.m00 = s;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = s;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = s;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = s;
    }

    public Mat4d(Mat4 m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m03 = m.m03;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m13 = m.m13;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
        this.m23 = m.m23;
        this.m30 = m.m30;
        this.m31 = m.m31;
        this.m32 = m.m32;
        this.m33 = m.m33;
    }

    public Mat4d(Mat4d m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m03 = m.m03;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m13 = m.m13;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
        this.m23 = m.m23;
        this.m30 = m.m30;
        this.m31 = m.m31;
        this.m32 = m.m32;
        this.m33 = m.m33;
    }

    public Mat4d(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23, double m30, double m31, double m32, double m33) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m30 = m30;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
    }

    public Mat4d set(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23, double m30, double m31, double m32, double m33) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m30 = m30;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
        return this;
    }

    public Mat4d set(Mat4d m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m03 = m.m03;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m13 = m.m13;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
        this.m23 = m.m23;
        this.m30 = m.m30;
        this.m31 = m.m31;
        this.m32 = m.m32;
        this.m33 = m.m33;
        return this;
    }

    public Mat4d set(Mat4 m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m03 = m.m03;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m13 = m.m13;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
        this.m23 = m.m23;
        this.m30 = m.m30;
        this.m31 = m.m31;
        this.m32 = m.m32;
        this.m33 = m.m33;
        return this;
    }

    public double det() {
        return (this.m00 * this.m11 - this.m01 * this.m10) * (this.m22 * this.m33 - this.m23 * this.m32) + (this.m02 * this.m10 - this.m00 * this.m12) * (this.m21 * this.m33 - this.m23 * this.m31) + (this.m00 * this.m13 - this.m03 * this.m10) * (this.m21 * this.m32 - this.m22 * this.m31) + (this.m01 * this.m12 - this.m02 * this.m11) * (this.m20 * this.m33 - this.m23 * this.m30) + (this.m03 * this.m11 - this.m01 * this.m13) * (this.m20 * this.m32 - this.m22 * this.m30) + (this.m02 * this.m13 - this.m03 * this.m12) * (this.m20 * this.m31 - this.m21 * this.m30);
    }

    public double det3() {
        return (this.m00 * this.m11 - this.m01 * this.m10) * this.m22 + (this.m02 * this.m10 - this.m00 * this.m12) * this.m21 + (this.m01 * this.m12 - this.m02 * this.m11) * this.m20;
    }

    public Mat4d identity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
        return this;
    }

    public Mat4d inverse() {
        return this.inverse(this);
    }

    public Mat4d inverse(Mat4d dest) {
        double a = this.m00 * this.m11 - this.m01 * this.m10;
        double b = this.m00 * this.m12 - this.m02 * this.m10;
        double c = this.m00 * this.m13 - this.m03 * this.m10;
        double d = this.m01 * this.m12 - this.m02 * this.m11;
        double e = this.m01 * this.m13 - this.m03 * this.m11;
        double f = this.m02 * this.m13 - this.m03 * this.m12;
        double g = this.m20 * this.m31 - this.m21 * this.m30;
        double h = this.m20 * this.m32 - this.m22 * this.m30;
        double i = this.m20 * this.m33 - this.m23 * this.m30;
        double j = this.m21 * this.m32 - this.m22 * this.m31;
        double k = this.m21 * this.m33 - this.m23 * this.m31;
        double l = this.m22 * this.m33 - this.m23 * this.m32;
        double det = a * l - b * k + c * j + d * i - e * h + f * g;
        det = 1.0 / det;
        dest.set((this.m11 * l - this.m12 * k + this.m13 * j) * det, (-this.m01 * l + this.m02 * k - this.m03 * j) * det, (this.m31 * f - this.m32 * e + this.m33 * d) * det, (-this.m21 * f + this.m22 * e - this.m23 * d) * det, (-this.m10 * l + this.m12 * i - this.m13 * h) * det, (this.m00 * l - this.m02 * i + this.m03 * h) * det, (-this.m30 * f + this.m32 * c - this.m33 * b) * det, (this.m20 * f - this.m22 * c + this.m23 * b) * det, (this.m10 * k - this.m11 * i + this.m13 * g) * det, (-this.m00 * k + this.m01 * i - this.m03 * g) * det, (this.m30 * e - this.m31 * c + this.m33 * a) * det, (-this.m20 * e + this.m21 * c - this.m23 * a) * det, (-this.m10 * j + this.m11 * h - this.m12 * g) * det, (this.m00 * j - this.m01 * h + this.m02 * g) * det, (-this.m30 * d + this.m31 * b - this.m32 * a) * det, (this.m20 * d - this.m21 * b + this.m22 * a) * det);
        return dest;
    }

    public Mat4d invTransp() {
        return this.invTransp3(this);
    }

    public Mat4d invTransp3(Mat4d dest) {
        double det = this.det3();
        double s = 1.0 / det;
        dest.set((this.m11 * this.m22 - this.m21 * this.m12) * s, (this.m20 * this.m12 - this.m10 * this.m22) * s, (this.m10 * this.m21 - this.m20 * this.m11) * s, 0.0, (this.m21 * this.m02 - this.m01 * this.m22) * s, (this.m00 * this.m22 - this.m20 * this.m02) * s, (this.m20 * this.m01 - this.m00 * this.m21) * s, 0.0, (this.m01 * this.m12 - this.m11 * this.m02) * s, (this.m10 * this.m02 - this.m00 * this.m12) * s, (this.m00 * this.m11 - this.m10 * this.m01) * s, 0.0, 0.0, 0.0, 0.0, 1.0);
        return dest;
    }

    public Vec4d mul(Vec4d v) {
        return this.mul(v, v);
    }

    public Vec4d mul(Vec4d right, Vec4d res) {
        res.set(this.m00 * right.x + this.m10 * right.y + this.m20 * right.z + this.m30 * right.w, this.m01 * right.x + this.m11 * right.y + this.m21 * right.z + this.m31 * right.w, this.m02 * right.x + this.m12 * right.y + this.m22 * right.z + this.m32 * right.w, this.m03 * right.x + this.m13 * right.y + this.m23 * right.z + this.m33 * right.w);
        return res;
    }

    public Mat4d mul_(Mat4d right) {
        return this.mul(right, new Mat4d());
    }

    public Mat4d mul(Mat4d right) {
        return this.mul(right, this);
    }

    public Mat4d mul(Mat4d right, Mat4d dest) {
        dest.set(this.m00 * right.m00 + this.m10 * right.m01 + this.m20 * right.m02 + this.m30 * right.m03, this.m01 * right.m00 + this.m11 * right.m01 + this.m21 * right.m02 + this.m31 * right.m03, this.m02 * right.m00 + this.m12 * right.m01 + this.m22 * right.m02 + this.m32 * right.m03, this.m03 * right.m00 + this.m13 * right.m01 + this.m23 * right.m02 + this.m33 * right.m03, this.m00 * right.m10 + this.m10 * right.m11 + this.m20 * right.m12 + this.m30 * right.m13, this.m01 * right.m10 + this.m11 * right.m11 + this.m21 * right.m12 + this.m31 * right.m13, this.m02 * right.m10 + this.m12 * right.m11 + this.m22 * right.m12 + this.m32 * right.m13, this.m03 * right.m10 + this.m13 * right.m11 + this.m23 * right.m12 + this.m33 * right.m13, this.m00 * right.m20 + this.m10 * right.m21 + this.m20 * right.m22 + this.m30 * right.m23, this.m01 * right.m20 + this.m11 * right.m21 + this.m21 * right.m22 + this.m31 * right.m23, this.m02 * right.m20 + this.m12 * right.m21 + this.m22 * right.m22 + this.m32 * right.m23, this.m03 * right.m20 + this.m13 * right.m21 + this.m23 * right.m22 + this.m33 * right.m23, this.m00 * right.m30 + this.m10 * right.m31 + this.m20 * right.m32 + this.m30 * right.m33, this.m01 * right.m30 + this.m11 * right.m31 + this.m21 * right.m32 + this.m31 * right.m33, this.m02 * right.m30 + this.m12 * right.m31 + this.m22 * right.m32 + this.m32 * right.m33, this.m03 * right.m30 + this.m13 * right.m31 + this.m23 * right.m32 + this.m33 * right.m33);
        return dest;
    }

    public Mat4d rotation(double angle, double x, double y, double z) {
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        double t = 1.0 - c;
        this.m00 = c + x * x * t;
        this.m11 = c + y * y * t;
        this.m22 = c + z * z * t;
        double tmp1 = x * y * t;
        double tmp2 = z * s;
        this.m01 = tmp1 + tmp2;
        this.m10 = tmp1 - tmp2;
        tmp1 = x * z * t;
        tmp2 = y * s;
        this.m02 = tmp1 - tmp2;
        this.m20 = tmp1 + tmp2;
        tmp1 = y * z * t;
        tmp2 = x * s;
        this.m12 = tmp1 + tmp2;
        this.m21 = tmp1 - tmp2;
        this.m03 = 0.0;
        this.m13 = 0.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
        return this;
    }

    public Mat4d rotate(double angle, Vec3d v) {
        return this.rotate(angle, v.x, v.y, v.z, this);
    }

    public Mat4d rotate(double angle, double x, double y, double z) {
        return this.rotate(angle, x, y, z, this);
    }

    public Mat4d rotate(double angle, double x, double y, double z, Mat4d dest) {
        double s = Math.sin(angle);
        double c = Math.cos(angle);
        double C = 1.0 - c;
        double xx = x * x;
        double xy = x * y;
        double xz = x * z;
        double yy = y * y;
        double yz = y * z;
        double zz = z * z;
        double rm00 = xx * C + c;
        double rm01 = xy * C + z * s;
        double rm02 = xz * C - y * s;
        double rm10 = xy * C - z * s;
        double rm11 = yy * C + c;
        double rm12 = yz * C + x * s;
        double rm20 = xz * C + y * s;
        double rm21 = yz * C - x * s;
        double rm22 = zz * C + c;
        double nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        double nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        double nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        double nm03 = this.m03 * rm00 + this.m13 * rm01 + this.m23 * rm02;
        double nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        double nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        double nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        double nm13 = this.m03 * rm10 + this.m13 * rm11 + this.m23 * rm12;
        dest.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        dest.m23 = this.m03 * rm20 + this.m13 * rm21 + this.m23 * rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        return dest;
    }

    public Mat4d scale(double s) {
        return this.scale(s, s, s);
    }

    public Mat4d scale(Vec3d v) {
        return this.scale(v.x, v.y, v.z);
    }

    public Mat4d scale(Vec3d v, Mat4d res) {
        return this.scale(v.x, v.y, v.z, res);
    }

    public Mat4d scale(double x, double y, double z) {
        return this.scale(x, y, z, this);
    }

    public Mat4d scale(double x, double y, double z, Mat4d dest) {
        dest.m00 = this.m00 * x;
        dest.m01 = this.m01 * x;
        dest.m02 = this.m02 * x;
        dest.m03 = this.m03 * x;
        dest.m10 = this.m10 * y;
        dest.m11 = this.m11 * y;
        dest.m12 = this.m12 * y;
        dest.m13 = this.m13 * y;
        dest.m20 = this.m20 * z;
        dest.m21 = this.m21 * z;
        dest.m22 = this.m22 * z;
        dest.m23 = this.m23 * z;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        return dest;
    }

    public Mat4d translation(double x, double y, double z) {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m23 = 0.0;
        this.m30 = x;
        this.m31 = y;
        this.m32 = z;
        this.m33 = 1.0;
        return this;
    }

    public Mat4d translate(Vec3d v) {
        return this.translate(this, v.x, v.y, v.z);
    }

    public Mat4d translate(double x, double y, double z) {
        return this.translate(this, x, y, z);
    }

    public Mat4d translate(Mat4d res, Vec3d v) {
        return this.translate(res, v.x, v.y, v.z);
    }

    public Mat4d translate(Mat4d res, double x, double y, double z) {
        res.m30 = res.m00 * x + res.m10 * y + res.m20 * z + res.m30;
        res.m31 = res.m01 * x + res.m11 * y + res.m21 * z + res.m31;
        res.m32 = res.m02 * x + res.m12 * y + res.m22 * z + res.m32;
        res.m33 = res.m03 * x + res.m13 * y + res.m23 * z + res.m33;
        return this;
    }

    public Mat4d lookAt(Vec3d eye, Vec3d center, Vec3d up) {
        return Glm.lookAt(eye, center, up, this);
    }

    public static Mat4d lookAt(Vec3d eye, Vec3d center, Vec3d up, Mat4d res) {
        return Glm.lookAt(eye, center, up, res);
    }

    public Mat4d ortho(double left, double right, double bottom, double top, double zNear, double zFar) {
        return Glm.ortho(this, left, right, bottom, top, zNear, zFar);
    }

    public Mat4d perspective(double fovy, double aspect, double zNear, double zFar) {
        return Glm.perspective(fovy, aspect, zNear, zFar, this);
    }

    public Mat4d perspectiveFov(double fov, double width, double height, double zNear, double zFar) {
        return Glm.perspectiveFov(fov, width, height, zNear, zFar, this);
    }

    public boolean equals3(Mat4d other) {
        return this.equals3(other, 2);
    }

    public boolean equals3(Mat4d other, int maxUlps) {
        if (!Glm.compareDoubleEquals(this.m00, other.m00, maxUlps)) {
            return false;
        }
        if (!Glm.compareDoubleEquals(this.m01, other.m01, maxUlps)) {
            return false;
        }
        if (!Glm.compareDoubleEquals(this.m02, other.m02, maxUlps)) {
            return false;
        }
        if (!Glm.compareDoubleEquals(this.m10, other.m10, maxUlps)) {
            return false;
        }
        if (!Glm.compareDoubleEquals(this.m11, other.m11, maxUlps)) {
            return false;
        }
        if (!Glm.compareDoubleEquals(this.m12, other.m12, maxUlps)) {
            return false;
        }
        if (!Glm.compareDoubleEquals(this.m20, other.m20, maxUlps)) {
            return false;
        }
        if (!Glm.compareDoubleEquals(this.m21, other.m21, maxUlps)) {
            return false;
        }
        return Glm.compareDoubleEquals(this.m22, other.m22, maxUlps);
    }

    public boolean equals(Mat4d other) {
        return this.equals(other, 2);
    }

    public boolean equals(Mat4d other, int maxUlps) {
        if (!Glm.compareDoubleEquals(this.m00, other.m00, maxUlps)) {
            return false;
        }
        if (!Glm.compareDoubleEquals(this.m01, other.m01, maxUlps)) {
            return false;
        }
        if (!Glm.compareDoubleEquals(this.m02, other.m02, maxUlps)) {
            return false;
        }
        if (!Glm.compareDoubleEquals(this.m03, other.m03, maxUlps)) {
            return false;
        }
        if (!Glm.compareDoubleEquals(this.m10, other.m10, maxUlps)) {
            return false;
        }
        if (!Glm.compareDoubleEquals(this.m11, other.m11, maxUlps)) {
            return false;
        }
        if (!Glm.compareDoubleEquals(this.m12, other.m12, maxUlps)) {
            return false;
        }
        if (!Glm.compareDoubleEquals(this.m13, other.m13, maxUlps)) {
            return false;
        }
        if (!Glm.compareDoubleEquals(this.m20, other.m20, maxUlps)) {
            return false;
        }
        if (!Glm.compareDoubleEquals(this.m21, other.m21, maxUlps)) {
            return false;
        }
        if (!Glm.compareDoubleEquals(this.m22, other.m22, maxUlps)) {
            return false;
        }
        if (!Glm.compareDoubleEquals(this.m23, other.m23, maxUlps)) {
            return false;
        }
        if (!Glm.compareDoubleEquals(this.m30, other.m30, maxUlps)) {
            return false;
        }
        if (!Glm.compareDoubleEquals(this.m31, other.m31, maxUlps)) {
            return false;
        }
        if (!Glm.compareDoubleEquals(this.m32, other.m32, maxUlps)) {
            return false;
        }
        return Glm.compareDoubleEquals(this.m33, other.m33, maxUlps);
    }

    public double[] toDa_() {
        return this.toDa(new double[16]);
    }

    public double[] toDa(double[] res) {
        return this.toFa(res, 0);
    }

    public double[] toFa(double[] res, int index) {
        res[index + 0] = this.m00;
        res[index + 1] = this.m01;
        res[index + 2] = this.m02;
        res[index + 3] = this.m03;
        res[index + 4] = this.m10;
        res[index + 5] = this.m11;
        res[index + 6] = this.m12;
        res[index + 7] = this.m13;
        res[index + 8] = this.m20;
        res[index + 9] = this.m21;
        res[index + 10] = this.m22;
        res[index + 11] = this.m23;
        res[index + 12] = this.m30;
        res[index + 13] = this.m31;
        res[index + 14] = this.m32;
        res[index + 15] = this.m33;
        return res;
    }

    public ByteBuffer toDbb_() {
        return this.toDbb(ByteBuffer.allocate(128));
    }

    public ByteBuffer toDbb(ByteBuffer res) {
        return this.toDbb(res, 0);
    }

    public ByteBuffer toDbb(ByteBuffer res, int index) {
        res.putDouble(index + 0, this.m00);
        res.putDouble(index + 1, this.m01);
        res.putDouble(index + 2, this.m02);
        res.putDouble(index + 3, this.m03);
        res.putDouble(index + 4, this.m10);
        res.putDouble(index + 5, this.m11);
        res.putDouble(index + 6, this.m12);
        res.putDouble(index + 7, this.m13);
        res.putDouble(index + 8, this.m20);
        res.putDouble(index + 9, this.m21);
        res.putDouble(index + 10, this.m22);
        res.putDouble(index + 11, this.m23);
        res.putDouble(index + 12, this.m30);
        res.putDouble(index + 13, this.m31);
        res.putDouble(index + 14, this.m32);
        res.putDouble(index + 15, this.m33);
        return res;
    }

    public void print() {
        this.print("", true);
    }

    public void print(String title) {
        this.print(title, true);
    }

    public void print(boolean outStream) {
        this.print("", outStream);
    }

    public void print(String title, boolean outStream) {
        String res = title + "\n| " + this.m00 + " " + this.m10 + " " + this.m20 + " " + this.m30 + " |\n| " + this.m01 + " " + this.m11 + " " + this.m21 + " " + this.m31 + " |\n| " + this.m02 + " " + this.m12 + " " + this.m22 + " " + this.m32 + " |\n| " + this.m03 + " " + this.m13 + " " + this.m23 + " " + this.m33 + " |\n";
        if (outStream) {
            System.out.print(res);
        } else {
            System.err.print(res);
        }
    }
}

