/*
 * Decompiled with CFR 0.152.
 */
package glm.vec._2;

import glm.vec._2.FuncRelational;
import glm.vec._2.i.Vec2i;
import glm.vec._3.Vec3;
import glm.vec._4.Vec4;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class Vec2
extends FuncRelational {
    public Vec2() {
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public Vec2(float f) {
        this.x = f;
        this.y = f;
    }

    public Vec2(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vec2(double f) {
        this.x = (float)f;
        this.y = (float)f;
    }

    public Vec2(double x, double y) {
        this.x = (float)x;
        this.y = (float)y;
    }

    public Vec2(Vec2 v) {
        this.x = v.x;
        this.y = v.y;
    }

    public Vec2(Vec2i v) {
        this.x = v.x;
        this.y = v.y;
    }

    public Vec2(Vec3 v) {
        this.x = v.x;
        this.y = v.y;
    }

    public Vec2(Vec4 v) {
        this.x = v.x;
        this.y = v.y;
    }

    public Vec2 set(float f) {
        this.x = f;
        this.y = f;
        return this;
    }

    public Vec2 set(double x, double y) {
        return this.set((float)x, (float)y);
    }

    public Vec2 set(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vec2 set(int[] ia) {
        this.x = ia[0];
        this.y = ia[1];
        return this;
    }

    public Vec2 set(float[] fa) {
        this.x = fa[0];
        this.y = fa[1];
        return this;
    }

    public float[] toFA_() {
        return this.toFA(new float[2]);
    }

    public float[] toFA(float[] fa) {
        fa[0] = this.x;
        fa[1] = this.y;
        return fa;
    }

    public FloatBuffer toDfb_() {
        return this.toDfb(ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder()).asFloatBuffer());
    }

    public FloatBuffer toDfb(FloatBuffer fb) {
        return this.toDfb(fb, 0);
    }

    public FloatBuffer toDfb(FloatBuffer fb, int index) {
        return fb.put(index + 0, this.x).put(index + 1, this.y);
    }

    public ByteBuffer toDbb_() {
        return this.toDbb(ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder()));
    }

    public ByteBuffer toDbb(ByteBuffer bb) {
        return this.toDbb(bb, 0);
    }

    public ByteBuffer toDbb(ByteBuffer bb, int index) {
        return bb.putFloat(index + 0, this.x).putFloat(index + 4, this.y);
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Vec2 normalize() {
        return this.normalize(this);
    }

    public Vec2 normalize(Vec2 dest) {
        float invLength = (float)(1.0 / Math.sqrt(this.x * this.x + this.y * this.y));
        dest.x = this.x * invLength;
        dest.y = this.y * invLength;
        return dest;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public void print() {
        this.print("", true);
    }

    public void print(String title) {
        this.print(title, true);
    }

    public void print(boolean outStream) {
        this.print("", outStream);
    }

    public void print(String title, boolean outStream) {
        String res = title + "\n(" + this.x + ", " + this.y + ")";
        if (outStream) {
            System.out.print(res);
        } else {
            System.err.print(res);
        }
    }
}

