/*
 * Decompiled with CFR 0.152.
 */
package glm.vec._3;

import glm.Glm;
import glm.vec._3.funcRelational;
import glm.vec._4.Vec4;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class Vec3
extends funcRelational {
    public Vec3() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Vec3(Vec3 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Vec3(Vec4 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Vec3(float f) {
        this.x = f;
        this.y = f;
        this.z = f;
    }

    public Vec3(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3(float[] fa) {
        this(fa, 0);
    }

    public Vec3(float[] fa, int i) {
        this.x = fa[i + 0];
        this.y = fa[i + 1];
        this.z = fa[i + 2];
    }

    public Vec3(double x, double y, double z) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
    }

    public Vec3 set(Vec3 v) {
        return this.set(v.x, v.y, v.z);
    }

    public Vec3 set(float f) {
        this.x = f;
        this.y = f;
        this.z = f;
        return this;
    }

    public Vec3 set(double x, double y, double z) {
        return this.set((float)x, (float)y, (float)z);
    }

    public Vec3 set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vec3 set(float[] fa) {
        this.x = fa[0];
        this.y = fa[1];
        this.z = fa[2];
        return this;
    }

    public static Vec3 linearRand_(Vec3 min, Vec3 max) {
        return Vec3.linearRand(min, max, new Vec3());
    }

    public static Vec3 linearRand(Vec3 min, Vec3 max, Vec3 res) {
        res.x = (float)Glm.linearRand(min.x, max.x);
        res.y = (float)Glm.linearRand(min.y, max.y);
        res.z = (float)Glm.linearRand(min.z, max.z);
        return res;
    }

    public Vec3 negate() {
        return this.negate(this);
    }

    public Vec3 negate_() {
        return this.negate(new Vec3());
    }

    public Vec3 negate(Vec3 res) {
        res.x = -this.x;
        res.y = -this.y;
        res.z = -this.z;
        return res;
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vec4 toVec4_() {
        return this.toVec4(new Vec4());
    }

    public Vec4 toVec4(Vec4 res) {
        return res.set(this.x, this.y, this.z, 1.0f);
    }

    public float[] toFa_() {
        return this.toFa(new float[3]);
    }

    public float[] toFa(float[] fa) {
        fa[0] = this.x;
        fa[1] = this.y;
        fa[2] = this.z;
        return fa;
    }

    public FloatBuffer toDfb_() {
        return this.toDfb(ByteBuffer.allocateDirect(12).order(ByteOrder.nativeOrder()).asFloatBuffer());
    }

    public FloatBuffer toDfb(FloatBuffer fb) {
        return this.toDfb(fb, 0);
    }

    public FloatBuffer toDfb(FloatBuffer fb, int index) {
        return fb.put(index + 0, this.x).put(index + 1, this.y).put(index + 2, this.z);
    }

    public ByteBuffer toDbb_() {
        return this.toDbb(ByteBuffer.allocateDirect(12).order(ByteOrder.nativeOrder()));
    }

    public ByteBuffer toDbb(ByteBuffer bb) {
        return this.toDbb(bb, 0);
    }

    public ByteBuffer toDbb(ByteBuffer bb, int index) {
        return bb.putFloat(index + 0, this.x).putFloat(index + 4, this.y).putFloat(index + 8, this.z);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public void print() {
        this.print("", System.out);
    }

    public void print(String title) {
        this.print(title, System.out);
    }

    public void print(String title, PrintStream printStream) {
        printStream.println(title + "\n(" + this.x + ", " + this.y + ", " + this.z + ")");
    }
}

