/*
 * Decompiled with CFR 0.152.
 */
package glm.vec._3;

import glm.Glm;
import glm.vec._3.ArithmeticOperators;
import glm.vec._3.Vec3;
import glm.vec._3.b.Vec3b;
import glm.vec._3.i.Vec3i;

abstract class funcCommon
extends ArithmeticOperators {
    funcCommon() {
    }

    public Vec3 abs() {
        return this.abs((Vec3)this);
    }

    public Vec3 abs_() {
        return this.abs(new Vec3());
    }

    public Vec3 abs(Vec3 result) {
        return funcCommon.abs((Vec3)this, result);
    }

    public static Vec3 abs(Vec3 x, Vec3 result) {
        result.x = Math.abs(x.x);
        result.y = Math.abs(x.y);
        result.z = Math.abs(x.z);
        return result;
    }

    public Vec3 ceil() {
        return this.ceil((Vec3)this);
    }

    public Vec3 ceil_() {
        return this.ceil(new Vec3());
    }

    public Vec3 ceil(Vec3 result) {
        return funcCommon.ceil((Vec3)this, (Vec3)this);
    }

    public static Vec3 ceil(Vec3 x, Vec3 result) {
        result.x = (float)Math.ceil(x.x);
        result.y = (float)Math.ceil(x.y);
        result.z = (float)Math.ceil(x.z);
        return result;
    }

    public Vec3 clamp(float minVal, float maxVal) {
        return this.clamp(minVal, maxVal, (Vec3)this);
    }

    public Vec3 clamp_(float minVal, float maxVal) {
        return this.clamp(minVal, maxVal, new Vec3());
    }

    public Vec3 clamp(float minVal, float maxVal, Vec3 result) {
        return funcCommon.clamp((Vec3)this, minVal, maxVal, result);
    }

    public static Vec3 clamp(Vec3 x, float minVal, float maxVal, Vec3 result) {
        result.x = Math.min(Math.max(x.x, minVal), maxVal);
        result.y = Math.min(Math.max(x.y, minVal), maxVal);
        result.z = Math.min(Math.max(x.z, minVal), maxVal);
        return result;
    }

    public Vec3 clamp(Vec3 minVal, Vec3 maxVal) {
        return this.clamp(minVal, maxVal, (Vec3)this);
    }

    public Vec3 clamp_(Vec3 minVal, Vec3 maxVal) {
        return this.clamp(minVal, maxVal, new Vec3());
    }

    public Vec3 clamp(Vec3 minVal, Vec3 maxVal, Vec3 result) {
        return funcCommon.clamp((Vec3)this, minVal, maxVal, result);
    }

    public static Vec3 clamp(Vec3 x, Vec3 minVal, Vec3 maxVal, Vec3 result) {
        result.x = Math.min(Math.max(x.x, minVal.x), maxVal.x);
        result.y = Math.min(Math.max(x.y, minVal.y), maxVal.y);
        result.z = Math.min(Math.max(x.z, minVal.z), maxVal.z);
        return result;
    }

    public Vec3i floatToIntBits_() {
        return funcCommon.floatToIntBits((Vec3)this, new Vec3i());
    }

    public Vec3i floatToIntBits(Vec3i result) {
        return funcCommon.floatToIntBits((Vec3)this, result);
    }

    public static Vec3i floatToIntBits(Vec3 x, Vec3i result) {
        result.x = Float.floatToIntBits(x.x);
        result.y = Float.floatToIntBits(x.y);
        result.z = Float.floatToIntBits(x.z);
        return result;
    }

    public Vec3 floor() {
        return this.floor((Vec3)this);
    }

    public Vec3 floor_() {
        return this.floor(new Vec3());
    }

    public Vec3 floor(Vec3 result) {
        return funcCommon.floor((Vec3)this, result);
    }

    public static Vec3 floor(Vec3 x, Vec3 result) {
        result.x = (float)Math.floor(x.x);
        result.y = (float)Math.floor(x.y);
        result.z = (float)Math.floor(x.z);
        return result;
    }

    public Vec3 fma(Vec3 b, Vec3 c) {
        return this.fma(b, c, (Vec3)this);
    }

    public Vec3 fma_(Vec3 b, Vec3 c) {
        return this.fma(b, c, new Vec3());
    }

    public Vec3 fma(Vec3 b, Vec3 c, Vec3 result) {
        return funcCommon.fma((Vec3)this, b, c, result);
    }

    public static Vec3 fma(Vec3 a, Vec3 b, Vec3 c, Vec3 result) {
        result.x = a.x * b.x + c.x;
        result.y = a.y * b.y + c.y;
        result.z = a.z * b.z + c.z;
        return result;
    }

    public Vec3 fract() {
        return this.fract((Vec3)this);
    }

    public Vec3 fract_() {
        return this.fract(new Vec3());
    }

    public Vec3 fract(Vec3 result) {
        return funcCommon.fract((Vec3)this, result);
    }

    public static Vec3 fract(Vec3 x, Vec3 result) {
        result.x = (float)((double)x.x - Math.floor(x.x));
        result.y = (float)((double)x.y - Math.floor(x.y));
        result.z = (float)((double)x.z - Math.floor(x.z));
        return result;
    }

    public Vec3b isInf_() {
        return funcCommon.isInf((Vec3)this, new Vec3b());
    }

    public Vec3b isInf(Vec3b result) {
        return funcCommon.isInf((Vec3)this, result);
    }

    public static Vec3b isInf(Vec3 x, Vec3b result) {
        result.x = (byte)(Float.isInfinite(x.x) ? 1 : 0);
        result.y = (byte)(Float.isInfinite(x.y) ? 1 : 0);
        result.z = (byte)(Float.isInfinite(x.z) ? 1 : 0);
        return result;
    }

    public Vec3b isNan() {
        return funcCommon.isNan((Vec3)this, new Vec3b());
    }

    public Vec3b isNan(Vec3b result) {
        return funcCommon.isNan((Vec3)this, result);
    }

    public static Vec3b isNan(Vec3 x, Vec3b result) {
        result.x = (byte)(Float.isNaN(x.x) ? 1 : 0);
        result.y = (byte)(Float.isNaN(x.y) ? 1 : 0);
        result.z = (byte)(Float.isNaN(x.z) ? 1 : 0);
        return result;
    }

    public Vec3 max(Vec3 y) {
        return this.max(y, (Vec3)this);
    }

    public Vec3 max_(Vec3 y) {
        return funcCommon.max((Vec3)this, y, new Vec3());
    }

    public Vec3 max(Vec3 y, Vec3 result) {
        return funcCommon.max((Vec3)this, y, result);
    }

    public static Vec3 max(Vec3 x, Vec3 y, Vec3 result) {
        result.x = Math.max(x.x, y.x);
        result.y = Math.max(x.y, y.y);
        result.z = Math.max(x.z, y.z);
        return result;
    }

    public Vec3 min(Vec3 y) {
        return this.min(y, (Vec3)this);
    }

    public Vec3 min_(Vec3 y) {
        return this.min(y, new Vec3());
    }

    public Vec3 min(Vec3 y, Vec3 result) {
        return funcCommon.min((Vec3)this, y, result);
    }

    public static Vec3 min(Vec3 x, Vec3 y, Vec3 result) {
        result.x = Math.min(x.x, y.x);
        result.y = Math.min(x.y, y.y);
        result.z = Math.min(x.z, y.z);
        return result;
    }

    public Vec3 mix(Vec3 y, boolean a) {
        return this.mix(y, a, (Vec3)this);
    }

    public Vec3 mix_(Vec3 y, boolean a) {
        return this.mix(y, a, new Vec3());
    }

    public Vec3 mix(Vec3 y, boolean a, Vec3 result) {
        return funcCommon.mix((Vec3)this, y, a, result);
    }

    public static Vec3 mix(Vec3 x, Vec3 y, boolean a, Vec3 result) {
        result.x = a ? y.x : x.x;
        result.y = a ? y.y : x.y;
        result.z = a ? y.z : x.z;
        return result;
    }

    public Vec3 mix(Vec3 y, Vec3b a) {
        return this.mix(y, a, (Vec3)this);
    }

    public Vec3 mix_(Vec3 y, Vec3b a) {
        return this.mix(y, a, new Vec3());
    }

    public Vec3 mix(Vec3 y, Vec3b a, Vec3 result) {
        return funcCommon.mix((Vec3)this, y, a, result);
    }

    public static Vec3 mix(Vec3 x, Vec3 y, Vec3b a, Vec3 result) {
        result.x = a.x == 1 ? y.x : x.x;
        result.y = a.y == 1 ? y.y : x.y;
        result.z = a.z == 1 ? y.z : x.z;
        return result;
    }

    public Vec3 mix(Vec3 y, float a) {
        return this.mix(y, a, (Vec3)this);
    }

    public Vec3 mix_(Vec3 y, float a) {
        return this.mix(y, a, new Vec3());
    }

    public Vec3 mix(Vec3 y, float a, Vec3 result) {
        return funcCommon.mix((Vec3)this, y, a, result);
    }

    public static Vec3 mix(Vec3 x, Vec3 y, float a, Vec3 result) {
        result.x = x.x + a * (y.x - x.x);
        result.y = x.y + a * (y.y - x.y);
        result.z = x.z + a * (y.z - x.z);
        return result;
    }

    public Vec3 mix(Vec3 y, Vec3 a) {
        return this.mix(y, a, (Vec3)this);
    }

    public Vec3 mix_(Vec3 y, Vec3 a) {
        return this.mix(y, a, new Vec3());
    }

    public Vec3 mix(Vec3 y, Vec3 a, Vec3 result) {
        return funcCommon.mix((Vec3)this, y, a, result);
    }

    public static Vec3 mix(Vec3 x, Vec3 y, Vec3 a, Vec3 result) {
        result.x = x.x + a.x * (y.x - x.x);
        result.y = x.y + a.y * (y.y - x.y);
        result.z = x.z + a.z * (y.z - x.z);
        return result;
    }

    public Vec3 mod(Vec3 y) {
        return this.mod(y, (Vec3)this);
    }

    public Vec3 mod_(Vec3 y) {
        return this.mod(y, new Vec3());
    }

    public Vec3 mod(Vec3 y, Vec3 result) {
        return funcCommon.mod((Vec3)this, y, result);
    }

    public static Vec3 mod(Vec3 x, Vec3 y, Vec3 result) {
        result.x = x.x - y.x * Glm.floor(x.x / y.x);
        result.y = x.y - y.y * Glm.floor(x.y / y.y);
        result.z = x.z - y.z * Glm.floor(x.z / y.z);
        return result;
    }

    public Vec3i round_() {
        return this.round(new Vec3i());
    }

    public Vec3i round(Vec3i result) {
        return funcCommon.round((Vec3)this, result);
    }

    public static Vec3i round(Vec3 x, Vec3i result) {
        result.x = Math.round(x.x);
        result.y = Math.round(x.y);
        result.z = Math.round(x.z);
        return result;
    }

    public Vec3 sign() {
        return funcCommon.sign((Vec3)this, (Vec3)this);
    }

    public Vec3 sign_() {
        return this.sign(new Vec3());
    }

    public Vec3 sign(Vec3 result) {
        return funcCommon.sign((Vec3)this, result);
    }

    public static Vec3 sign(Vec3 x, Vec3 result) {
        result.x = Math.signum(x.x);
        result.y = Math.signum(x.y);
        result.z = Math.signum(x.z);
        return result;
    }

    public Vec3 smoothStep(Vec3 edge0, Vec3 edge1) {
        return this.smoothStep(edge0, edge1, (Vec3)this);
    }

    public Vec3 smoothStep_(Vec3 edge0, Vec3 edge1) {
        return this.smoothStep(edge0, edge1, new Vec3());
    }

    public Vec3 smoothStep(Vec3 edge0, Vec3 edge1, Vec3 result) {
        return funcCommon.smoothStep(edge0, edge1, (Vec3)this, result);
    }

    public static Vec3 smoothStep(Vec3 edge0, Vec3 edge1, Vec3 x, Vec3 result) {
        float tmpX = Math.min(Math.max((x.x - edge0.x) / (edge1.x - edge0.x), 0.0f), 1.0f);
        float tmpY = Math.min(Math.max((x.y - edge0.y) / (edge1.y - edge0.y), 0.0f), 1.0f);
        float tmpZ = Math.min(Math.max((x.z - edge0.z) / (edge1.z - edge0.z), 0.0f), 1.0f);
        result.x = tmpX * tmpX * (3.0f - 2.0f * tmpX);
        result.y = tmpY * tmpY * (3.0f - 2.0f * tmpY);
        result.z = tmpZ * tmpZ * (3.0f - 2.0f * tmpZ);
        return result;
    }

    public Vec3 step(Vec3 edge) {
        return this.step(edge, (Vec3)this);
    }

    public Vec3 step_(Vec3 edge) {
        return this.step(edge, new Vec3());
    }

    public Vec3 step(Vec3 edge, Vec3 result) {
        return funcCommon.step(edge, (Vec3)this, result);
    }

    public static Vec3 step(Vec3 edge, Vec3 x, Vec3 result) {
        float ltX = x.x < edge.x ? 1.0f : 0.0f;
        float ltY = x.y < edge.y ? 1.0f : 0.0f;
        float ltZ = x.z < edge.z ? 1.0f : 0.0f;
        result.x = 1.0f + ltX * -1.0f;
        result.y = 1.0f + ltY * -1.0f;
        result.z = 1.0f + ltZ * -1.0f;
        return result;
    }

    public Vec3 toUnsignedFloat() {
        return this.toUnsignedFloat((Vec3)this);
    }

    public Vec3 toUnsignedFloat_() {
        return this.toUnsignedFloat(new Vec3());
    }

    public Vec3 toUnsignedFloat(Vec3 result) {
        return funcCommon.toUnsignedFloat((Vec3)this, result);
    }

    public static Vec3 toUnsignedFloat(Vec3 x, Vec3 result) {
        result.x = Float.intBitsToFloat((int)x.x);
        result.y = Float.intBitsToFloat((int)x.y);
        result.z = Float.intBitsToFloat((int)x.z);
        return result;
    }
}

